/************************************************************************************************/
/* Stata User File for H201 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H201.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H201.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H201.DO                                               */
/* The program below will output the Stata dataset H201.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL 17-18
  str    FAMID31 19-20
  str    FAMID42 21-22
  str    FAMID53 23-24
  str    FAMID17 25-26
  str    FAMIDYR 27-28
  str    CPSFAMID 29-30
  byte   FCSZ1231 31-32
  byte   FCRP1231 33-34
  str    RULETR31 35-36
  str    RULETR42 37-38
  str    RULETR53 39-40
  str    RULETR17 41-42
  byte   RUSIZE31 43-44
  byte   RUSIZE42 45-46
  byte   RUSIZE53 47-48
  byte   RUSIZE17 49-50
  byte   RUCLAS31 51-52
  byte   RUCLAS42 53-54
  byte   RUCLAS53 55-56
  byte   RUCLAS17 57-57
  byte   FAMSZE31 58-59
  byte   FAMSZE42 60-61
  byte   FAMSZE53 62-63
  byte   FAMSZE17 64-65
  byte   FMRS1231 66-67
  byte   FAMS1231 68-69
  byte   FAMSZEYR 70-71
  byte   FAMRFPYR 72-72
  byte   REGION31 73-74
  byte   REGION42 75-76
  byte   REGION53 77-78
  byte   REGION17 79-80
  int    REFPRS31 81-83
  int    REFPRS42 84-86
  int    REFPRS53 87-89
  int    REFPRS17 90-92
  byte   RESP31 93-93
  byte   RESP42 94-94
  byte   RESP53 95-95
  byte   RESP17 96-96
  byte   PROXY31 97-98
  byte   PROXY42 99-100
  byte   PROXY53 101-102
  byte   PROXY17 103-103
  byte   INTVLANG 104-105
  byte   BEGRFM31 106-107
  int    BEGRFY31 108-111
  byte   ENDRFM31 112-113
  int    ENDRFY31 114-117
  byte   BEGRFM42 118-119
  int    BEGRFY42 120-123
  byte   ENDRFM42 124-125
  int    ENDRFY42 126-129
  byte   BEGRFM53 130-131
  int    BEGRFY53 132-135
  byte   ENDRFM53 136-137
  int    ENDRFY53 138-141
  byte   ENDRFM17 142-143
  int    ENDRFY17 144-147
  byte   KEYNESS 148-148
  byte   INSCOP31 149-149
  byte   INSCOP42 150-150
  byte   INSCOP53 151-151
  byte   INSCOP17 152-152
  byte   INSC1231 153-153
  byte   INSCOPE 154-154
  byte   ELGRND31 155-155
  byte   ELGRND42 156-156
  byte   ELGRND53 157-157
  byte   ELGRND17 158-158
  byte   PSTATS31 159-160
  byte   PSTATS42 161-162
  byte   PSTATS53 163-164
  str    RURSLT31 165-166
  str    RURSLT42 167-168
  str    RURSLT53 169-170
  byte   AGE31X 171-172
  byte   AGE42X 173-174
  byte   AGE53X 175-176
  byte   AGE17X 177-178
  byte   AGELAST 179-180
  byte   DOBMM 181-182
  int    DOBYY 183-186
  byte   SEX 187-187
  byte   RACEV1X 188-188
  byte   RACEV2X 189-190
  byte   RACEAX 191-191
  byte   RACEBX 192-192
  byte   RACEWX 193-193
  byte   RACETHX 194-194
  byte   HISPANX 195-195
  byte   HISPNCAT 196-196
  byte   MARRY31X 197-198
  byte   MARRY42X 199-200
  byte   MARRY53X 201-202
  byte   MARRY17X 203-204
  int    SPOUID31 205-207
  int    SPOUID42 208-210
  int    SPOUID53 211-213
  int    SPOUID17 214-216
  byte   SPOUIN31 217-218
  byte   SPOUIN42 219-220
  byte   SPOUIN53 221-222
  byte   SPOUIN17 223-224
  byte   EDUCYR 225-226
  byte   HIDEG 227-228
  byte   FTSTU31X 229-230
  byte   FTSTU42X 231-232
  byte   FTSTU53X 233-234
  byte   FTSTU17X 235-236
  byte   ACTDTY31 237-238
  byte   ACTDTY42 239-240
  byte   ACTDTY53 241-242
  byte   HONRDC31 243-244
  byte   HONRDC42 245-246
  byte   HONRDC53 247-248
  byte   REFRL31X 249-250
  byte   REFRL42X 251-252
  byte   REFRL53X 253-254
  byte   REFRL17X 255-256
  byte   OTHLANG 257-258
  byte   LANGSPK 259-260
  byte   HWELLSPE 261-262
  byte   BORNUSA 263-264
  byte   YRSINUS 265-266
  int    MOPID31X 267-269
  int    MOPID42X 270-272
  int    MOPID53X 273-275
  int    DAPID31X 276-278
  int    DAPID42X 279-281
  int    DAPID53X 282-284
  byte   RTHLTH31 285-286
  byte   RTHLTH42 287-288
  byte   RTHLTH53 289-290
  byte   MNHLTH31 291-292
  byte   MNHLTH42 293-294
  byte   MNHLTH53 295-296
  byte   HIBPDX 297-298
  byte   HIBPAGED 299-300
  byte   BPMLDX 301-302
  byte   CHDDX 303-304
  byte   CHDAGED 305-306
  byte   ANGIDX 307-308
  byte   ANGIAGED 309-310
  byte   MIDX 311-312
  byte   MIAGED 313-314
  byte   OHRTDX 315-316
  byte   OHRTAGED 317-318
  byte   STRKDX 319-320
  byte   STRKAGED 321-322
  byte   EMPHDX 323-324
  byte   EMPHAGED 325-326
  byte   CHBRON31 327-328
  byte   CHOLDX 329-330
  byte   CHOLAGED 331-332
  byte   CANCERDX 333-334
  byte   CABLADDR 335-336
  byte   CABREAST 337-338
  byte   CACERVIX 339-340
  byte   CACOLON 341-342
  byte   CALUNG 343-344
  byte   CALYMPH 345-346
  byte   CAMELANO 347-348
  byte   CAOTHER 349-350
  byte   CAPROSTA 351-352
  byte   CASKINNM 353-354
  byte   CASKINDK 355-356
  byte   CAUTERUS 357-358
  byte   DIABDX 359-360
  byte   DIABAGED 361-362
  byte   JTPAIN31 363-364
  byte   ARTHDX 365-366
  byte   ARTHTYPE 367-368
  byte   ARTHAGED 369-370
  byte   ASTHDX 371-372
  byte   ASTHAGED 373-374
  byte   ASSTIL31 375-376
  byte   ASATAK31 377-378
  byte   ASTHEP31 379-380
  byte   ADHDADDX 381-382
  byte   ADHDAGED 383-384
  byte   IADLHP31 385-386
  byte   ADLHLP31 387-388
  byte   AIDHLP31 389-390
  byte   WLKLIM31 391-392
  byte   LFTDIF31 393-394
  byte   STPDIF31 395-396
  byte   WLKDIF31 397-398
  byte   MILDIF31 399-400
  byte   STNDIF31 401-402
  byte   BENDIF31 403-404
  byte   RCHDIF31 405-406
  byte   FNGRDF31 407-408
  byte   ACTLIM31 409-410
  byte   WRKLIM31 411-412
  byte   HSELIM31 413-414
  byte   SCHLIM31 415-416
  byte   UNABLE31 417-418
  byte   SOCLIM31 419-420
  byte   COGLIM31 421-422
  byte   DFHEAR42 423-424
  byte   DEAF42 425-426
  byte   DFSEE42 427-428
  byte   BLIND42 429-430
  byte   DFCOG42 431-432
  byte   DFWLKC42 433-434
  byte   DFDRSB42 435-436
  byte   DFERND42 437-438
  byte   HEARAD42 439-440
  byte   WRGLAS42 441-442
  byte   ANYLMI17 443-444
  byte   CHPMED42 445-446
  byte   CHPMHB42 447-448
  byte   CHPMCN42 449-450
  byte   CHSERV42 451-452
  byte   CHSRHB42 453-454
  byte   CHSRCN42 455-456
  byte   CHLIMI42 457-458
  byte   CHLIHB42 459-460
  byte   CHLICO42 461-462
  byte   CHTHER42 463-464
  byte   CHTHHB42 465-466
  byte   CHTHCO42 467-468
  byte   CHCOUN42 469-470
  byte   CHEMPB42 471-472
  byte   CSHCN42 473-474
  byte   MOMPRO42 475-476
  byte   DADPRO42 477-478
  byte   UNHAP42 479-480
  byte   SCHLBH42 481-482
  byte   HAVFUN42 483-484
  byte   ADUPRO42 485-486
  byte   NERVAF42 487-488
  byte   SIBPRO42 489-490
  byte   KIDPRO42 491-492
  byte   SPRPRO42 493-494
  byte   SCHPRO42 495-496
  byte   HOMEBH42 497-498
  byte   TRBLE42 499-500
  byte   CHILCR42 501-502
  byte   CHILWW42 503-504
  byte   CHRTCR42 505-506
  byte   CHRTWW42 507-508
  byte   CHAPPT42 509-510
  byte   CHNDCR42 511-512
  byte   CHENEC42 513-514
  byte   CHLIST42 515-516
  byte   CHEXPL42 517-518
  byte   CHRESP42 519-520
  byte   CHPRTM42 521-522
  byte   CHHECR42 523-524
  byte   CHSPEC42 525-526
  byte   CHEYRE42 527-528
  byte   MESHGT42 529-530
  byte   WHNHGT42 531-532
  byte   MESWGT42 533-534
  byte   WHNWGT42 535-536
  double CHBMIX42 537-541
  byte   MESVIS42 542-543
  byte   MESBPR42 544-545
  byte   WHNBPR42 546-547
  byte   DENTAL42 548-549
  byte   WHNDEN42 550-551
  byte   EATHLT42 552-553
  byte   WHNEAT42 554-555
  byte   PHYSCL42 556-557
  byte   WHNPHY42 558-559
  byte   SAFEST42 560-561
  byte   WHNSAF42 562-563
  byte   BOOST42 564-565
  byte   WHNBST42 566-567
  byte   LAPBLT42 568-569
  byte   WHNLAP42 570-571
  byte   HELMET42 572-573
  byte   WHNHEL42 574-575
  byte   NOSMOK42 576-577
  byte   WHNSMK42 578-579
  byte   TIMALN42 580-581
  byte   LSTETH53 582-583
  byte   PHYEXE53 584-585
  byte   OFTSMK53 586-587
  byte   SAQELIG 588-588
  byte   ADPROX42 589-590
  byte   ADGENH42 591-592
  byte   ADDAYA42 593-594
  byte   ADCLIM42 595-596
  byte   ADACLS42 597-598
  byte   ADWKLM42 599-600
  byte   ADEMLS42 601-602
  byte   ADMWCF42 603-604
  byte   ADPAIN42 605-606
  byte   ADPCFL42 607-608
  byte   ADENGY42 609-610
  byte   ADPRST42 611-612
  byte   ADSOCA42 613-614
  double VPCS42 615-619
  double VMCS42 620-624
  byte   VRFLAG42 625-626
  byte   ADNERV42 627-628
  byte   ADHOPE42 629-630
  byte   ADREST42 631-632
  byte   ADSAD42 633-634
  byte   ADEFRT42 635-636
  byte   ADWRTH42 637-638
  byte   K6SUM42 639-640
  byte   ADINTR42 641-642
  byte   ADDPRS42 643-644
  byte   PHQ242 645-646
  byte   ADINSA42 647-648
  byte   ADINSB42 649-650
  byte   ADRISK42 651-652
  byte   ADOVER42 653-654
  byte   ADILCR42 655-656
  byte   ADILWW42 657-658
  byte   ADRTCR42 659-660
  byte   ADRTWW42 661-662
  byte   ADAPPT42 663-664
  byte   ADHECR42 665-666
  byte   ADINST42 667-668
  byte   ADEZUN42 669-670
  byte   ADTLHW42 671-672
  byte   ADFFRM42 673-674
  byte   ADFHLP42 675-676
  byte   ADEXPL42 677-678
  byte   ADLIST42 679-680
  byte   ADRESP42 681-682
  byte   ADPRTM42 683-684
  byte   ADSMOK42 685-686
  byte   ADNSMK42 687-688
  byte   ADSPCL42 689-690
  byte   ADSNSP42 691-692
  byte   ADCMPM42 693-694
  int    ADCMPY42 695-698
  byte   ADLANG42 699-700
  byte   DSDIA53 701-702
  byte   DSA1C53 703-704
  byte   DSFT1853 705-706
  byte   DSFT1753 707-708
  byte   DSFT1653 709-710
  byte   DSFB1653 711-712
  byte   DSFTNV53 713-714
  byte   DSEY1853 715-716
  byte   DSEY1753 717-718
  byte   DSEY1653 719-720
  byte   DSEB1653 721-722
  byte   DSEYNV53 723-724
  byte   DSCH1853 725-726
  byte   DSCH1753 727-728
  byte   DSCH1653 729-730
  byte   DSCB1653 731-732
  byte   DSCHNV53 733-734
  byte   DSFL1853 735-736
  byte   DSFL1753 737-738
  byte   DSFL1653 739-740
  byte   DSVB1653 741-742
  byte   DSFLNV53 743-744
  byte   DSKIDN53 745-746
  byte   DSEYPR53 747-748
  byte   DSDIET53 749-750
  byte   DSMED53 751-752
  byte   DSINSU53 753-754
  byte   DSCPCP53 755-756
  byte   DSCNPC53 757-758
  byte   DSCPHN53 759-760
  byte   DSCINT53 761-762
  byte   DSCGRP53 763-764
  byte   DSCONF53 765-766
  byte   DSPRX53 767-768
  byte   CCNRDI31 769-770
  byte   CDIAG31 771-772
  byte   CTRTMT31 773-774
  byte   CLSTRT31 775-776
  byte   CBCK31 777-778
  int    CBCKYR31 779-782
  byte   CFTRT31 783-784
  byte   CWRKP31 785-786
  byte   CTMOFF31 787-788
  byte   CWYCNG31 789-790
  byte   CEXTM31 791-792
  byte   CEXTDI31 793-794
  byte   CEXTRT31 795-796
  byte   CEXTLT31 797-798
  byte   CEXTMT31 799-800
  byte   CNPTLD31 801-802
  byte   CNGFLX31 803-804
  byte   CPROM31 805-806
  byte   CERET31 807-808
  byte   CPTASK31 809-810
  byte   CMTASK31 811-812
  byte   CLPROD31 813-814
  byte   CFRET31 815-816
  byte   CLHINS31 817-818
  byte   CCLHIN31 819-820
  byte   CSLHIN31 821-822
  byte   CFMEM31 823-824
  byte   CFMSPS31 825-826
  byte   CFMCHD31 827-828
  byte   CFMSIB31 829-830
  byte   CFMPAR31 831-832
  byte   CFMREL31 833-834
  byte   CFMFND31 835-836
  byte   CFMOTR31 837-838
  byte   CFMTOF31 839-840
  byte   CFM2MT31 841-842
  byte   CINCOV31 843-844
  byte   CINPRV31 845-846
  byte   CINMDC31 847-848
  byte   CINMDG31 849-850
  byte   CINMDA31 851-852
  byte   CINMLT31 853-854
  byte   CINIHS31 855-856
  byte   CINSHP31 857-858
  byte   CINOGP31 859-860
  byte   CINSSP31 861-862
  byte   CINNCV31 863-864
  byte   CINNOC31 865-866
  byte   CINADQ31 867-868
  byte   CINCMP31 869-870
  byte   CINDIF31 871-872
  byte   CINAFD31 873-874
  byte   CNCMED31 875-876
  byte   CNCTRP31 877-878
  byte   CNCLOD31 879-880
  byte   CNCCHD31 881-882
  byte   CNCHME31 883-884
  byte   CNCNON31 885-886
  byte   CNCNTS31 887-888
  byte   CFNDBT31 889-890
  byte   CFNAMT31 891-892
  byte   CFNVAC31 893-894
  byte   CFNPUR31 895-896
  byte   CFNSPD31 897-898
  byte   CFNSAV31 899-900
  byte   CFNLIV31 901-902
  byte   CFNOTH31 903-904
  byte   CFNUNB31 905-906
  byte   CFNBNK31 907-908
  byte   CFNPMT31 909-910
  byte   CFNSTB31 911-912
  byte   CFNINC31 913-914
  byte   CMCFUP31 915-916
  byte   CMCEFF31 917-918
  byte   CMCPSY31 919-920
  byte   CMCSTY31 921-922
  byte   CMCOST31 923-924
  byte   CMCTRT31 925-926
  byte   CDLPRS31 927-928
  byte   CDLVST31 929-930
  byte   CDLTRT31 931-932
  byte   CDLFUP31 933-934
  byte   CDLMNT31 935-936
  byte   CDLOTH31 937-938
  byte   CMCNEC31 939-940
  byte   CMNAFF31 941-942
  byte   CMNINS31 943-944
  byte   CMNACC31 945-946
  byte   CMNOFF31 947-948
  byte   CMNTIM31 949-950
  byte   CMNPLC31 951-952
  byte   CMNCRE31 953-954
  byte   CMNLNG31 955-956
  byte   CEFACT31 957-958
  byte   CEFLCT31 959-960
  byte   CEFOG31 961-962
  byte   CEFMTL31 963-964
  byte   CEFUND31 965-966
  byte   CEFBCK31 967-968
  byte   CEFSTG31 969-970
  byte   CEFCOP31 971-972
  byte   CEFPOS31 973-974
  byte   CEFHLT31 975-976
  byte   CEFPHL31 977-978
  byte   CEFPAC31 979-980
  byte   CEFPIN31 981-982
  byte   CEFFTG31 983-984
  byte   CEFQLF31 985-986
  byte   CEFMHL31 987-988
  byte   CEFRLT31 989-990
  byte   CEFMPR31 991-992
  byte   DDNWRK17 993-994
  byte   OTHDYS17 995-996
  byte   OTHNDD17 997-998
  byte   ACCELI42 999-1000
  byte   HAVEUS42 1001-1002
  byte   YNOUSC42 1003-1004
  byte   NOREAS42 1005-1006
  byte   SELDSI42 1007-1008
  byte   NEWARE42 1009-1010
  byte   DKWHRU42 1011-1012
  byte   USCNOT42 1013-1014
  byte   PERSLA42 1015-1016
  byte   DIFFPL42 1017-1018
  byte   INSRPL42 1019-1020
  byte   MYSELF42 1021-1022
  byte   CARECO42 1023-1024
  byte   NOHINS42 1025-1026
  byte   OTHINS42 1027-1028
  byte   JOBRSN42 1029-1030
  byte   NEWDOC42 1031-1032
  byte   DOCELS42 1033-1034
  byte   NOLIKE42 1035-1036
  byte   HEALTH42 1037-1038
  byte   KNOWDR42 1039-1040
  byte   NOGODR42 1041-1042
  byte   TRANS42 1043-1044
  byte   CLINIC42 1045-1046
  byte   OTHREA42 1047-1048
  byte   PROVTY42 1049-1050
  byte   PLCTYP42 1051-1052
  byte   TMTKUS42 1053-1054
  byte   TYPEPE42 1055-1056
  byte   LOCATN42 1057-1058
  byte   HSPLAP42 1059-1060
  byte   WHITPR42 1061-1062
  byte   BLCKPR42 1063-1064
  byte   ASIANP42 1065-1066
  byte   NATAMP42 1067-1068
  byte   PACISP42 1069-1070
  byte   OTHRCP42 1071-1072
  byte   GENDRP42 1073-1074
  byte   MINORP42 1075-1076
  byte   PREVEN42 1077-1078
  byte   REFFRL42 1079-1080
  byte   ONGONG42 1081-1082
  byte   PHNREG42 1083-1084
  byte   OFFHOU42 1085-1086
  byte   AFTHOU42 1087-1088
  byte   TREATM42 1089-1090
  byte   RESPCT42 1091-1092
  byte   DECIDE42 1093-1094
  byte   EXPLOP42 1095-1096
  byte   PRVSPK42 1097-1098
  byte   MDUNAB42 1099-1100
  byte   MDUNRS42 1101-1102
  byte   MDDLAY42 1103-1104
  byte   MDDLRS42 1105-1106
  byte   DNUNAB42 1107-1108
  byte   DNUNRS42 1109-1110
  byte   DNDLAY42 1111-1112
  byte   DNDLRS42 1113-1114
  byte   PMUNAB42 1115-1116
  byte   PMUNRS42 1117-1118
  byte   PMDLAY42 1119-1120
  byte   PMDLRS42 1121-1122
  byte   EMPST31 1123-1124
  byte   EMPST42 1125-1126
  byte   EMPST53 1127-1128
  byte   RNDFLG31 1129-1130
  byte   MORJOB31 1131-1132
  byte   MORJOB42 1133-1134
  byte   MORJOB53 1135-1136
  byte   EVRWRK 1137-1138
  double HRWG31X 1139-1144
  double HRWG42X 1145-1150
  double HRWG53X 1151-1156
  byte   HRWGIM31 1157-1157
  byte   HRWGIM42 1158-1158
  byte   HRWGIM53 1159-1159
  byte   HRHOW31 1160-1161
  byte   HRHOW42 1162-1163
  byte   HRHOW53 1164-1165
  byte   DIFFWG31 1166-1167
  byte   DIFFWG42 1168-1169
  byte   DIFFWG53 1170-1171
  double NHRWG31 1172-1177
  double NHRWG42 1178-1183
  double NHRWG53 1184-1189
  int    HOUR31 1190-1192
  int    HOUR42 1193-1195
  int    HOUR53 1196-1198
  byte   TEMPJB31 1199-1200
  byte   TEMPJB42 1201-1202
  byte   TEMPJB53 1203-1204
  byte   SSNLJB31 1205-1206
  byte   SSNLJB42 1207-1208
  byte   SSNLJB53 1209-1210
  byte   SELFCM31 1211-1212
  byte   SELFCM42 1213-1214
  byte   SELFCM53 1215-1216
  byte   DISVW31X 1217-1218
  byte   DISVW42X 1219-1220
  byte   DISVW53X 1221-1222
  byte   CHOIC31 1223-1224
  byte   CHOIC42 1225-1226
  byte   CHOIC53 1227-1228
  byte   INDCAT31 1229-1230
  byte   INDCAT42 1231-1232
  byte   INDCAT53 1233-1234
  int    NUMEMP31 1235-1237
  int    NUMEMP42 1238-1240
  int    NUMEMP53 1241-1243
  byte   MORE31 1244-1245
  byte   MORE42 1246-1247
  byte   MORE53 1248-1249
  byte   UNION31 1250-1251
  byte   UNION42 1252-1253
  byte   UNION53 1254-1255
  byte   NWK31 1256-1257
  byte   NWK42 1258-1259
  byte   NWK53 1260-1261
  byte   CHGJ3142 1262-1263
  byte   CHGJ4253 1264-1265
  byte   YCHJ3142 1266-1267
  byte   YCHJ4253 1268-1269
  byte   STJBMM31 1270-1271
  int    STJBYY31 1272-1275
  byte   STJBMM42 1276-1277
  int    STJBYY42 1278-1281
  byte   STJBMM53 1282-1283
  int    STJBYY53 1284-1287
  byte   EVRETIRE 1288-1289
  byte   OCCCAT31 1290-1291
  byte   OCCCAT42 1292-1293
  byte   OCCCAT53 1294-1295
  byte   PAYVAC31 1296-1297
  byte   PAYVAC42 1298-1299
  byte   PAYVAC53 1300-1301
  byte   SICPAY31 1302-1303
  byte   SICPAY42 1304-1305
  byte   SICPAY53 1306-1307
  byte   PAYDR31 1308-1309
  byte   PAYDR42 1310-1311
  byte   PAYDR53 1312-1313
  byte   RETPLN31 1314-1315
  byte   RETPLN42 1316-1317
  byte   RETPLN53 1318-1319
  byte   BSNTY31 1320-1321
  byte   BSNTY42 1322-1323
  byte   BSNTY53 1324-1325
  byte   JOBORG31 1326-1327
  byte   JOBORG42 1328-1329
  byte   JOBORG53 1330-1331
  byte   HELD31X 1332-1333
  byte   HELD42X 1334-1335
  byte   HELD53X 1336-1337
  byte   OFFER31X 1338-1339
  byte   OFFER42X 1340-1341
  byte   OFFER53X 1342-1343
  byte   OFREMP31 1344-1345
  byte   OFREMP42 1346-1347
  byte   OFREMP53 1348-1349
  byte   EMPST31H 1350-1351
  byte   EMPST42H 1352-1353
  byte   EMPST53H 1354-1355
  byte   SLFCM31H 1356-1357
  byte   SLFCM42H 1358-1359
  byte   SLFCM53H 1360-1361
  int    NMEMP31H 1362-1364
  int    NMEMP42H 1365-1367
  int    NMEMP53H 1368-1370
  byte   MORE31H 1371-1372
  byte   MORE42H 1373-1374
  byte   MORE53H 1375-1376
  byte   INDCT31H 1377-1378
  byte   INDCT42H 1379-1380
  byte   INDCT53H 1381-1382
  byte   OCCCT31H 1383-1384
  byte   OCCCT42H 1385-1386
  byte   OCCCT53H 1387-1388
  int    HOUR31H 1389-1391
  int    HOUR42H 1392-1394
  int    HOUR53H 1395-1397
  byte   JBORG31H 1398-1399
  byte   JBORG42H 1400-1401
  byte   JBORG53H 1402-1403
  byte   UNION31H 1404-1405
  byte   UNION42H 1406-1407
  byte   UNION53H 1408-1409
  byte   BSNTY31H 1410-1411
  byte   BSNTY42H 1412-1413
  byte   BSNTY53H 1414-1415
  double HRWG31H 1416-1421
  double HRWG42H 1422-1427
  double HRWG53H 1428-1433
  byte   CMJHLD31 1434-1435
  byte   CMJHLD42 1436-1437
  byte   CMJHLD53 1438-1439
  byte   OFFER31H 1440-1441
  byte   OFFER42H 1442-1443
  byte   OFFER53H 1444-1445
  byte   OFEMP31H 1446-1447
  byte   OFEMP42H 1448-1449
  byte   OFEMP53H 1450-1451
  byte   PYVAC31H 1452-1453
  byte   PYVAC42H 1454-1455
  byte   PYVAC53H 1456-1457
  byte   SCPAY31H 1458-1459
  byte   SCPAY42H 1460-1461
  byte   SCPAY53H 1462-1463
  byte   PAYDR31H 1464-1465
  byte   PAYDR42H 1466-1467
  byte   PAYDR53H 1468-1469
  byte   RTPLN31H 1470-1471
  byte   RTPLN42H 1472-1473
  byte   RTPLN53H 1474-1475
  byte   FILEDR17 1476-1477
  byte   WILFIL17 1478-1479
  byte   FLSTAT17 1480-1481
  byte   FILER17 1482-1483
  byte   JTINRU17 1484-1485
  int    JNTPID17 1486-1488
  byte   TAXFRM17 1489-1490
  byte   FOODST17 1491-1492
  byte   FOODMN17 1493-1494
  int    FOODVL17 1495-1498
  long   TTLP17X 1499-1504
  long   FAMINC17 1505-1510
  byte   POVCAT17 1511-1511
  double POVLEV17 1512-1522
  long   WAGEP17X 1523-1528
  byte   WAGIMP17 1529-1529
  long   BUSNP17X 1530-1535
  byte   BUSIMP17 1536-1536
  int    UNEMP17X 1537-1540
  byte   UNEIMP17 1541-1541
  long   WCMPP17X 1542-1546
  byte   WCPIMP17 1547-1547
  long   INTRP17X 1548-1552
  byte   INTIMP17 1553-1553
  long   DIVDP17X 1554-1559
  byte   DIVIMP17 1560-1560
  long   SALEP17X 1561-1567
  byte   SALIMP17 1568-1568
  long   PENSP17X 1569-1573
  byte   PENIMP17 1574-1574
  long   SSECP17X 1575-1579
  byte   SSCIMP17 1580-1580
  long   TRSTP17X 1581-1586
  byte   TRTIMP17 1587-1587
  long   VETSP17X 1588-1592
  byte   VETIMP17 1593-1593
  long   IRASP17X 1594-1599
  byte   IRAIMP17 1600-1600
  long   ALIMP17X 1601-1605
  byte   ALIIMP17 1606-1606
  long   CHLDP17X 1607-1611
  byte   CHLIMP17 1612-1612
  long   CASHP17X 1613-1618
  byte   CSHIMP17 1619-1619
  long   SSIP17X 1620-1624
  byte   SSIIMP17 1625-1625
  long   PUBP17X 1626-1630
  byte   PUBIMP17 1631-1631
  long   OTHRP17X 1632-1637
  byte   OTHIMP17 1638-1638
  str    HIEUIDX 1639-1645
  byte   TRIJA17X 1646-1647
  byte   TRIFE17X 1648-1649
  byte   TRIMA17X 1650-1651
  byte   TRIAP17X 1652-1653
  byte   TRIMY17X 1654-1655
  byte   TRIJU17X 1656-1657
  byte   TRIJL17X 1658-1659
  byte   TRIAU17X 1660-1661
  byte   TRISE17X 1662-1663
  byte   TRIOC17X 1664-1665
  byte   TRINO17X 1666-1667
  byte   TRIDE17X 1668-1669
  byte   MCRJA17 1670-1671
  byte   MCRFE17 1672-1673
  byte   MCRMA17 1674-1675
  byte   MCRAP17 1676-1677
  byte   MCRMY17 1678-1679
  byte   MCRJU17 1680-1681
  byte   MCRJL17 1682-1683
  byte   MCRAU17 1684-1685
  byte   MCRSE17 1686-1687
  byte   MCROC17 1688-1689
  byte   MCRNO17 1690-1691
  byte   MCRDE17 1692-1693
  byte   MCRJA17X 1694-1695
  byte   MCRFE17X 1696-1697
  byte   MCRMA17X 1698-1699
  byte   MCRAP17X 1700-1701
  byte   MCRMY17X 1702-1703
  byte   MCRJU17X 1704-1705
  byte   MCRJL17X 1706-1707
  byte   MCRAU17X 1708-1709
  byte   MCRSE17X 1710-1711
  byte   MCROC17X 1712-1713
  byte   MCRNO17X 1714-1715
  byte   MCRDE17X 1716-1717
  byte   MCDJA17 1718-1719
  byte   MCDFE17 1720-1721
  byte   MCDMA17 1722-1723
  byte   MCDAP17 1724-1725
  byte   MCDMY17 1726-1727
  byte   MCDJU17 1728-1729
  byte   MCDJL17 1730-1731
  byte   MCDAU17 1732-1733
  byte   MCDSE17 1734-1735
  byte   MCDOC17 1736-1737
  byte   MCDNO17 1738-1739
  byte   MCDDE17 1740-1741
  byte   MCDJA17X 1742-1743
  byte   MCDFE17X 1744-1745
  byte   MCDMA17X 1746-1747
  byte   MCDAP17X 1748-1749
  byte   MCDMY17X 1750-1751
  byte   MCDJU17X 1752-1753
  byte   MCDJL17X 1754-1755
  byte   MCDAU17X 1756-1757
  byte   MCDSE17X 1758-1759
  byte   MCDOC17X 1760-1761
  byte   MCDNO17X 1762-1763
  byte   MCDDE17X 1764-1765
  byte   OPAJA17 1766-1767
  byte   OPAFE17 1768-1769
  byte   OPAMA17 1770-1771
  byte   OPAAP17 1772-1773
  byte   OPAMY17 1774-1775
  byte   OPAJU17 1776-1777
  byte   OPAJL17 1778-1779
  byte   OPAAU17 1780-1781
  byte   OPASE17 1782-1783
  byte   OPAOC17 1784-1785
  byte   OPANO17 1786-1787
  byte   OPADE17 1788-1789
  byte   OPBJA17 1790-1791
  byte   OPBFE17 1792-1793
  byte   OPBMA17 1794-1795
  byte   OPBAP17 1796-1797
  byte   OPBMY17 1798-1799
  byte   OPBJU17 1800-1801
  byte   OPBJL17 1802-1803
  byte   OPBAU17 1804-1805
  byte   OPBSE17 1806-1807
  byte   OPBOC17 1808-1809
  byte   OPBNO17 1810-1811
  byte   OPBDE17 1812-1813
  byte   PUBJA17X 1814-1815
  byte   PUBFE17X 1816-1817
  byte   PUBMA17X 1818-1819
  byte   PUBAP17X 1820-1821
  byte   PUBMY17X 1822-1823
  byte   PUBJU17X 1824-1825
  byte   PUBJL17X 1826-1827
  byte   PUBAU17X 1828-1829
  byte   PUBSE17X 1830-1831
  byte   PUBOC17X 1832-1833
  byte   PUBNO17X 1834-1835
  byte   PUBDE17X 1836-1837
  byte   PEGJA17 1838-1839
  byte   PEGFE17 1840-1841
  byte   PEGMA17 1842-1843
  byte   PEGAP17 1844-1845
  byte   PEGMY17 1846-1847
  byte   PEGJU17 1848-1849
  byte   PEGJL17 1850-1851
  byte   PEGAU17 1852-1853
  byte   PEGSE17 1854-1855
  byte   PEGOC17 1856-1857
  byte   PEGNO17 1858-1859
  byte   PEGDE17 1860-1861
  byte   PDKJA17 1862-1863
  byte   PDKFE17 1864-1865
  byte   PDKMA17 1866-1867
  byte   PDKAP17 1868-1869
  byte   PDKMY17 1870-1871
  byte   PDKJU17 1872-1873
  byte   PDKJL17 1874-1875
  byte   PDKAU17 1876-1877
  byte   PDKSE17 1878-1879
  byte   PDKOC17 1880-1881
  byte   PDKNO17 1882-1883
  byte   PDKDE17 1884-1885
  byte   PNGJA17 1886-1887
  byte   PNGFE17 1888-1889
  byte   PNGMA17 1890-1891
  byte   PNGAP17 1892-1893
  byte   PNGMY17 1894-1895
  byte   PNGJU17 1896-1897
  byte   PNGJL17 1898-1899
  byte   PNGAU17 1900-1901
  byte   PNGSE17 1902-1903
  byte   PNGOC17 1904-1905
  byte   PNGNO17 1906-1907
  byte   PNGDE17 1908-1909
  byte   POGJA17 1910-1911
  byte   POGFE17 1912-1913
  byte   POGMA17 1914-1915
  byte   POGAP17 1916-1917
  byte   POGMY17 1918-1919
  byte   POGJU17 1920-1921
  byte   POGJL17 1922-1923
  byte   POGAU17 1924-1925
  byte   POGSE17 1926-1927
  byte   POGOC17 1928-1929
  byte   POGNO17 1930-1931
  byte   POGDE17 1932-1933
  byte   PRSJA17 1934-1935
  byte   PRSFE17 1936-1937
  byte   PRSMA17 1938-1939
  byte   PRSAP17 1940-1941
  byte   PRSMY17 1942-1943
  byte   PRSJU17 1944-1945
  byte   PRSJL17 1946-1947
  byte   PRSAU17 1948-1949
  byte   PRSSE17 1950-1951
  byte   PRSOC17 1952-1953
  byte   PRSNO17 1954-1955
  byte   PRSDE17 1956-1957
  byte   POUJA17 1958-1959
  byte   POUFE17 1960-1961
  byte   POUMA17 1962-1963
  byte   POUAP17 1964-1965
  byte   POUMY17 1966-1967
  byte   POUJU17 1968-1969
  byte   POUJL17 1970-1971
  byte   POUAU17 1972-1973
  byte   POUSE17 1974-1975
  byte   POUOC17 1976-1977
  byte   POUNO17 1978-1979
  byte   POUDE17 1980-1981
  byte   PRXJA17 1982-1983
  byte   PRXFE17 1984-1985
  byte   PRXMA17 1986-1987
  byte   PRXAP17 1988-1989
  byte   PRXMY17 1990-1991
  byte   PRXJU17 1992-1993
  byte   PRXJL17 1994-1995
  byte   PRXAU17 1996-1997
  byte   PRXSE17 1998-1999
  byte   PRXOC17 2000-2001
  byte   PRXNO17 2002-2003
  byte   PRXDE17 2004-2005
  byte   PRIJA17 2006-2007
  byte   PRIFE17 2008-2009
  byte   PRIMA17 2010-2011
  byte   PRIAP17 2012-2013
  byte   PRIMY17 2014-2015
  byte   PRIJU17 2016-2017
  byte   PRIJL17 2018-2019
  byte   PRIAU17 2020-2021
  byte   PRISE17 2022-2023
  byte   PRIOC17 2024-2025
  byte   PRINO17 2026-2027
  byte   PRIDE17 2028-2029
  byte   HPEJA17 2030-2031
  byte   HPEFE17 2032-2033
  byte   HPEMA17 2034-2035
  byte   HPEAP17 2036-2037
  byte   HPEMY17 2038-2039
  byte   HPEJU17 2040-2041
  byte   HPEJL17 2042-2043
  byte   HPEAU17 2044-2045
  byte   HPESE17 2046-2047
  byte   HPEOC17 2048-2049
  byte   HPENO17 2050-2051
  byte   HPEDE17 2052-2053
  byte   HPDJA17 2054-2055
  byte   HPDFE17 2056-2057
  byte   HPDMA17 2058-2059
  byte   HPDAP17 2060-2061
  byte   HPDMY17 2062-2063
  byte   HPDJU17 2064-2065
  byte   HPDJL17 2066-2067
  byte   HPDAU17 2068-2069
  byte   HPDSE17 2070-2071
  byte   HPDOC17 2072-2073
  byte   HPDNO17 2074-2075
  byte   HPDDE17 2076-2077
  byte   HPNJA17 2078-2079
  byte   HPNFE17 2080-2081
  byte   HPNMA17 2082-2083
  byte   HPNAP17 2084-2085
  byte   HPNMY17 2086-2087
  byte   HPNJU17 2088-2089
  byte   HPNJL17 2090-2091
  byte   HPNAU17 2092-2093
  byte   HPNSE17 2094-2095
  byte   HPNOC17 2096-2097
  byte   HPNNO17 2098-2099
  byte   HPNDE17 2100-2101
  byte   HPOJA17 2102-2103
  byte   HPOFE17 2104-2105
  byte   HPOMA17 2106-2107
  byte   HPOAP17 2108-2109
  byte   HPOMY17 2110-2111
  byte   HPOJU17 2112-2113
  byte   HPOJL17 2114-2115
  byte   HPOAU17 2116-2117
  byte   HPOSE17 2118-2119
  byte   HPOOC17 2120-2121
  byte   HPONO17 2122-2123
  byte   HPODE17 2124-2125
  byte   HPSJA17 2126-2127
  byte   HPSFE17 2128-2129
  byte   HPSMA17 2130-2131
  byte   HPSAP17 2132-2133
  byte   HPSMY17 2134-2135
  byte   HPSJU17 2136-2137
  byte   HPSJL17 2138-2139
  byte   HPSAU17 2140-2141
  byte   HPSSE17 2142-2143
  byte   HPSOC17 2144-2145
  byte   HPSNO17 2146-2147
  byte   HPSDE17 2148-2149
  byte   HPXJA17 2150-2151
  byte   HPXFE17 2152-2153
  byte   HPXMA17 2154-2155
  byte   HPXAP17 2156-2157
  byte   HPXMY17 2158-2159
  byte   HPXJU17 2160-2161
  byte   HPXJL17 2162-2163
  byte   HPXAU17 2164-2165
  byte   HPXSE17 2166-2167
  byte   HPXOC17 2168-2169
  byte   HPXNO17 2170-2171
  byte   HPXDE17 2172-2173
  byte   HPRJA17 2174-2175
  byte   HPRFE17 2176-2177
  byte   HPRMA17 2178-2179
  byte   HPRAP17 2180-2181
  byte   HPRMY17 2182-2183
  byte   HPRJU17 2184-2185
  byte   HPRJL17 2186-2187
  byte   HPRAU17 2188-2189
  byte   HPRSE17 2190-2191
  byte   HPROC17 2192-2193
  byte   HPRNO17 2194-2195
  byte   HPRDE17 2196-2197
  byte   INSJA17X 2198-2199
  byte   INSFE17X 2200-2201
  byte   INSMA17X 2202-2203
  byte   INSAP17X 2204-2205
  byte   INSMY17X 2206-2207
  byte   INSJU17X 2208-2209
  byte   INSJL17X 2210-2211
  byte   INSAU17X 2212-2213
  byte   INSSE17X 2214-2215
  byte   INSOC17X 2216-2217
  byte   INSNO17X 2218-2219
  byte   INSDE17X 2220-2221
  byte   PRVEV17 2222-2222
  byte   TRIEV17 2223-2223
  byte   MCREV17 2224-2224
  byte   MCDEV17 2225-2225
  byte   OPAEV17 2226-2226
  byte   OPBEV17 2227-2227
  byte   UNINS17 2228-2228
  byte   INSCOV17 2229-2229
  byte   INSURC17 2230-2230
  byte   TRIST31X 2231-2232
  byte   TRIST42X 2233-2234
  byte   TRIST17X 2235-2236
  byte   TRIPR31X 2237-2238
  byte   TRIPR42X 2239-2240
  byte   TRIPR17X 2241-2242
  byte   TRIEX31X 2243-2244
  byte   TRIEX42X 2245-2246
  byte   TRIEX17X 2247-2248
  byte   TRILI31X 2249-2250
  byte   TRILI42X 2251-2252
  byte   TRILI17X 2253-2254
  byte   TRICH31X 2255-2256
  byte   TRICH42X 2257-2258
  byte   TRICH17X 2259-2260
  byte   MCRPD31 2261-2262
  byte   MCRPD42 2263-2264
  byte   MCRPD17 2265-2266
  byte   MCRPD31X 2267-2268
  byte   MCRPD42X 2269-2270
  byte   MCRPD17X 2271-2272
  byte   MCRPB31 2273-2274
  byte   MCRPB42 2275-2276
  byte   MCRPB17 2277-2278
  byte   MCRPHO31 2279-2280
  byte   MCRPHO42 2281-2282
  byte   MCRPHO17 2283-2284
  byte   MCDHMO31 2285-2286
  byte   MCDHMO42 2287-2288
  byte   MCDHMO17 2289-2290
  byte   MCDMC31 2291-2292
  byte   MCDMC42 2293-2294
  byte   MCDMC17 2295-2296
  byte   PRVHMO31 2297-2298
  byte   PRVHMO42 2299-2300
  byte   PRVHMO17 2301-2302
  byte   FSAGT31 2303-2304
  byte   HASFSA31 2305-2306
  double FSAAMT31 2307-2314
  byte   PROBPY42 2315-2316
  byte   CRFMPY42 2317-2318
  byte   PYUNBL42 2319-2320
  byte   PREVCOVR 2321-2322
  byte   COVRMM 2323-2324
  int    COVRYY 2325-2328
  byte   WASESTB 2329-2330
  byte   WASMCARE 2331-2332
  byte   WASMCAID 2333-2334
  byte   WASCHAMP 2335-2336
  byte   WASVA 2337-2338
  byte   WASPRIV 2339-2340
  byte   WASOTGOV 2341-2342
  byte   WASAFDC 2343-2344
  byte   WASSSI 2345-2346
  byte   WASSTAT1 2347-2348
  byte   WASSTAT2 2349-2350
  byte   WASSTAT3 2351-2352
  byte   WASSTAT4 2353-2354
  byte   WASOTHER 2355-2356
  byte   NOINSBEF 2357-2358
  byte   NOINSTM 2359-2360
  byte   NOINUNIT 2361-2362
  byte   MORECOVR 2363-2364
  byte   INSENDMM 2365-2366
  int    INSENDYY 2367-2370
  byte   TRICR31X 2371-2372
  byte   TRICR42X 2373-2374
  byte   TRICR53X 2375-2376
  byte   TRICR17X 2377-2378
  byte   TRIAT31X 2379-2380
  byte   TRIAT42X 2381-2382
  byte   TRIAT53X 2383-2384
  byte   TRIAT17X 2385-2386
  byte   MCAID31 2387-2388
  byte   MCAID42 2389-2390
  byte   MCAID53 2391-2392
  byte   MCAID17 2393-2394
  byte   MCAID31X 2395-2396
  byte   MCAID42X 2397-2398
  byte   MCAID53X 2399-2400
  byte   MCAID17X 2401-2402
  byte   MCARE31 2403-2404
  byte   MCARE42 2405-2406
  byte   MCARE53 2407-2408
  byte   MCARE17 2409-2410
  byte   MCARE31X 2411-2412
  byte   MCARE42X 2413-2414
  byte   MCARE53X 2415-2416
  byte   MCARE17X 2417-2418
  byte   MCDAT31X 2419-2420
  byte   MCDAT42X 2421-2422
  byte   MCDAT53X 2423-2424
  byte   MCDAT17X 2425-2426
  byte   OTPAAT31 2427-2428
  byte   OTPAAT42 2429-2430
  byte   OTPAAT53 2431-2432
  byte   OTPAAT17 2433-2434
  byte   OTPBAT31 2435-2436
  byte   OTPBAT42 2437-2438
  byte   OTPBAT53 2439-2440
  byte   OTPBAT17 2441-2442
  byte   OTPUBA31 2443-2444
  byte   OTPUBA42 2445-2446
  byte   OTPUBA53 2447-2448
  byte   OTPUBA17 2449-2450
  byte   OTPUBB31 2451-2452
  byte   OTPUBB42 2453-2454
  byte   OTPUBB53 2455-2456
  byte   OTPUBB17 2457-2458
  byte   PRIDK31 2459-2460
  byte   PRIDK42 2461-2462
  byte   PRIDK53 2463-2464
  byte   PRIDK17 2465-2466
  byte   PRIEU31 2467-2468
  byte   PRIEU42 2469-2470
  byte   PRIEU53 2471-2472
  byte   PRIEU17 2473-2474
  byte   PRING31 2475-2476
  byte   PRING42 2477-2478
  byte   PRING53 2479-2480
  byte   PRING17 2481-2482
  byte   PRIOG31 2483-2484
  byte   PRIOG42 2485-2486
  byte   PRIOG53 2487-2488
  byte   PRIOG17 2489-2490
  byte   PRIS31 2491-2492
  byte   PRIS42 2493-2494
  byte   PRIS53 2495-2496
  byte   PRIS17 2497-2498
  byte   PROUT31 2499-2500
  byte   PROUT42 2501-2502
  byte   PROUT53 2503-2504
  byte   PROUT17 2505-2506
  byte   PRSTX31 2507-2508
  byte   PRSTX42 2509-2510
  byte   PRSTX53 2511-2512
  byte   PRSTX17 2513-2514
  byte   PRIV31 2515-2516
  byte   PRIV42 2517-2518
  byte   PRIV53 2519-2520
  byte   PRIV17 2521-2522
  byte   PRIVAT31 2523-2524
  byte   PRIVAT42 2525-2526
  byte   PRIVAT53 2527-2528
  byte   PRIVAT17 2529-2530
  byte   PUB31X 2531-2532
  byte   PUB42X 2533-2534
  byte   PUB53X 2535-2536
  byte   PUB17X 2537-2538
  byte   PUBAT31X 2539-2540
  byte   PUBAT42X 2541-2542
  byte   PUBAT53X 2543-2544
  byte   PUBAT17X 2545-2546
  byte   INS31X 2547-2548
  byte   INS42X 2549-2550
  byte   INS53X 2551-2552
  byte   INS17X 2553-2554
  byte   INSAT31X 2555-2556
  byte   INSAT42X 2557-2558
  byte   INSAT53X 2559-2560
  byte   INSAT17X 2561-2562
  byte   DENTIN31 2563-2564
  byte   DENTIN42 2565-2566
  byte   DENTIN53 2567-2568
  byte   DNTINS31 2569-2570
  byte   DNTINS17 2571-2572
  byte   PMEDIN31 2573-2574
  byte   PMEDIN42 2575-2576
  byte   PMEDIN53 2577-2578
  byte   PMDINS31 2579-2580
  byte   PMDINS17 2581-2582
  byte   PMEDUP31 2583-2584
  byte   PMEDUP42 2585-2586
  byte   PMEDUP53 2587-2588
  byte   PMEDPY31 2589-2590
  byte   PMEDPY42 2591-2592
  byte   PMEDPY53 2593-2594
  long   TOTTCH17 2595-2601
  long   TOTEXP17 2602-2607
  long   TOTSLF17 2608-2613
  long   TOTMCR17 2614-2619
  long   TOTMCD17 2620-2625
  long   TOTPRV17 2626-2631
  long   TOTVA17 2632-2637
  long   TOTTRI17 2638-2642
  long   TOTOFD17 2643-2647
  long   TOTSTL17 2648-2653
  long   TOTWCP17 2654-2659
  long   TOTOPR17 2660-2664
  long   TOTOPU17 2665-2669
  long   TOTOSR17 2670-2675
  long   TOTPTR17 2676-2681
  long   TOTOTH17 2682-2687
  int    OBTOTV17 2688-2690
  long   OBVTCH17 2691-2697
  long   OBVEXP17 2698-2703
  long   OBVSLF17 2704-2708
  long   OBVMCR17 2709-2714
  long   OBVMCD17 2715-2720
  long   OBVPRV17 2721-2726
  long   OBVVA17 2727-2731
  long   OBVTRI17 2732-2736
  int    OBVOFD17 2737-2740
  long   OBVSTL17 2741-2745
  long   OBVWCP17 2746-2750
  long   OBVOPR17 2751-2755
  long   OBVOPU17 2756-2760
  long   OBVOSR17 2761-2765
  long   OBVPTR17 2766-2771
  long   OBVOTH17 2772-2776
  int    OBDRV17 2777-2779
  long   OBDTCH17 2780-2785
  long   OBDEXP17 2786-2791
  long   OBDSLF17 2792-2796
  long   OBDMCR17 2797-2802
  long   OBDMCD17 2803-2808
  long   OBDPRV17 2809-2814
  long   OBDVA17 2815-2819
  long   OBDTRI17 2820-2824
  int    OBDOFD17 2825-2828
  long   OBDSTL17 2829-2833
  long   OBDWCP17 2834-2838
  long   OBDOPR17 2839-2843
  long   OBDOPU17 2844-2848
  long   OBDOSR17 2849-2853
  long   OBDPTR17 2854-2859
  long   OBDOTH17 2860-2864
  int    OPTOTV17 2865-2867
  long   OPTTCH17 2868-2874
  long   OPTEXP17 2875-2880
  long   OPTSLF17 2881-2885
  long   OPTMCR17 2886-2890
  long   OPTMCD17 2891-2895
  long   OPTPRV17 2896-2901
  long   OPTVA17 2902-2906
  long   OPTTRI17 2907-2911
  int    OPTOFD17 2912-2914
  int    OPTSTL17 2915-2918
  long   OPTWCP17 2919-2924
  long   OPTOPR17 2925-2929
  int    OPTOPU17 2930-2933
  long   OPTOSR17 2934-2939
  long   OPTPTR17 2940-2945
  long   OPTOTH17 2946-2951
  long   OPFTCH17 2952-2958
  long   OPFEXP17 2959-2964
  long   OPFSLF17 2965-2969
  long   OPFMCR17 2970-2974
  long   OPFMCD17 2975-2979
  long   OPFPRV17 2980-2985
  long   OPFVA17 2986-2990
  long   OPFTRI17 2991-2995
  int    OPFOFD17 2996-2998
  int    OPFSTL17 2999-3002
  long   OPFWCP17 3003-3008
  long   OPFOPR17 3009-3013
  int    OPFOPU17 3014-3017
  long   OPFOSR17 3018-3023
  long   OPFPTR17 3024-3029
  long   OPFOTH17 3030-3035
  long   OPDEXP17 3036-3040
  long   OPDTCH17 3041-3046
  int    OPDSLF17 3047-3050
  long   OPDMCR17 3051-3055
  int    OPDMCD17 3056-3059
  long   OPDPRV17 3060-3064
  int    OPDVA17 3065-3068
  int    OPDTRI17 3069-3072
  byte   OPDOFD17 3073-3073
  int    OPDSTL17 3074-3076
  int    OPDWCP17 3077-3080
  long   OPDOPR17 3081-3085
  int    OPDOPU17 3086-3089
  long   OPDOSR17 3090-3094
  long   OPDPTR17 3095-3099
  long   OPDOTH17 3100-3104
  byte   OPDRV17 3105-3106
  long   OPVTCH17 3107-3113
  long   OPVEXP17 3114-3119
  long   OPVSLF17 3120-3124
  long   OPVMCR17 3125-3129
  long   OPVMCD17 3130-3134
  long   OPVPRV17 3135-3139
  long   OPVVA17 3140-3144
  long   OPVTRI17 3145-3149
  int    OPVOFD17 3150-3152
  int    OPVSTL17 3153-3156
  long   OPVWCP17 3157-3162
  long   OPVOPR17 3163-3167
  int    OPVOPU17 3168-3170
  long   OPVOSR17 3171-3176
  long   OPVPTR17 3177-3181
  long   OPVOTH17 3182-3187
  long   OPSEXP17 3188-3192
  long   OPSTCH17 3193-3198
  int    OPSSLF17 3199-3202
  int    OPSMCR17 3203-3206
  int    OPSMCD17 3207-3210
  long   OPSPRV17 3211-3215
  int    OPSVA17 3216-3219
  int    OPSTRI17 3220-3223
  byte   OPSOFD17 3224-3224
  int    OPSSTL17 3225-3227
  int    OPSWCP17 3228-3231
  long   OPSOPR17 3232-3236
  int    OPSOPU17 3237-3240
  long   OPSOSR17 3241-3245
  long   OPSPTR17 3246-3250
  long   OPSOTH17 3251-3255
  byte   ERTOT17 3256-3257
  long   ERTTCH17 3258-3263
  long   ERTEXP17 3264-3268
  int    ERTSLF17 3269-3272
  long   ERTMCR17 3273-3277
  long   ERTMCD17 3278-3282
  long   ERTPRV17 3283-3287
  long   ERTVA17 3288-3292
  int    ERTTRI17 3293-3296
  int    ERTOFD17 3297-3300
  int    ERTSTL17 3301-3304
  long   ERTWCP17 3305-3309
  long   ERTOPR17 3310-3314
  int    ERTOPU17 3315-3318
  long   ERTOSR17 3319-3323
  long   ERTPTR17 3324-3328
  long   ERTOTH17 3329-3333
  long   ERFTCH17 3334-3339
  long   ERFEXP17 3340-3344
  int    ERFSLF17 3345-3348
  long   ERFMCR17 3349-3353
  long   ERFMCD17 3354-3358
  long   ERFPRV17 3359-3363
  long   ERFVA17 3364-3368
  int    ERFTRI17 3369-3372
  int    ERFOFD17 3373-3376
  int    ERFSTL17 3377-3380
  long   ERFWCP17 3381-3385
  int    ERFOPR17 3386-3389
  int    ERFOPU17 3390-3393
  long   ERFOSR17 3394-3398
  long   ERFPTR17 3399-3403
  long   ERFOTH17 3404-3408
  long   ERDEXP17 3409-3413
  long   ERDTCH17 3414-3418
  int    ERDSLF17 3419-3422
  int    ERDMCR17 3423-3426
  long   ERDMCD17 3427-3431
  int    ERDPRV17 3432-3435
  int    ERDVA17 3436-3439
  int    ERDTRI17 3440-3443
  byte   ERDOFD17 3444-3444
  int    ERDSTL17 3445-3447
  int    ERDWCP17 3448-3451
  int    ERDOPR17 3452-3455
  int    ERDOPU17 3456-3458
  int    ERDOSR17 3459-3462
  int    ERDPTR17 3463-3466
  int    ERDOTH17 3467-3470
  byte   IPDIS17 3471-3472
  long   IPTEXP17 3473-3478
  long   IPTTCH17 3479-3485
  long   IPTSLF17 3486-3490
  long   IPTMCR17 3491-3496
  long   IPTMCD17 3497-3502
  long   IPTPRV17 3503-3508
  long   IPTVA17 3509-3514
  long   IPTTRI17 3515-3519
  int    IPTOFD17 3520-3523
  long   IPTSTL17 3524-3528
  long   IPTWCP17 3529-3533
  long   IPTOPR17 3534-3538
  long   IPTOPU17 3539-3543
  long   IPTOSR17 3544-3548
  long   IPTPTR17 3549-3554
  long   IPTOTH17 3555-3560
  long   IPFEXP17 3561-3566
  long   IPFTCH17 3567-3573
  long   IPFSLF17 3574-3578
  long   IPFMCR17 3579-3584
  long   IPFMCD17 3585-3590
  long   IPFPRV17 3591-3596
  long   IPFVA17 3597-3602
  long   IPFTRI17 3603-3607
  int    IPFOFD17 3608-3611
  long   IPFSTL17 3612-3616
  long   IPFWCP17 3617-3621
  long   IPFOPR17 3622-3626
  long   IPFOPU17 3627-3631
  long   IPFOSR17 3632-3636
  long   IPFPTR17 3637-3642
  long   IPFOTH17 3643-3647
  long   IPDEXP17 3648-3652
  long   IPDTCH17 3653-3658
  int    IPDSLF17 3659-3662
  long   IPDMCR17 3663-3667
  long   IPDMCD17 3668-3672
  long   IPDPRV17 3673-3677
  long   IPDVA17 3678-3682
  int    IPDTRI17 3683-3686
  int    IPDOFD17 3687-3689
  int    IPDSTL17 3690-3692
  long   IPDWCP17 3693-3697
  int    IPDOPR17 3698-3701
  int    IPDOPU17 3702-3705
  long   IPDOSR17 3706-3710
  long   IPDPTR17 3711-3715
  long   IPDOTH17 3716-3720
  int    IPNGTD17 3721-3723
  byte   DVTOT17 3724-3725
  long   DVTTCH17 3726-3730
  long   DVTEXP17 3731-3735
  long   DVTSLF17 3736-3740
  int    DVTMCR17 3741-3744
  long   DVTMCD17 3745-3749
  long   DVTPRV17 3750-3754
  int    DVTVA17 3755-3758
  int    DVTTRI17 3759-3762
  int    DVTOFD17 3763-3765
  int    DVTSTL17 3766-3769
  int    DVTWCP17 3770-3772
  int    DVTOPR17 3773-3776
  int    DVTOPU17 3777-3780
  int    DVTOSR17 3781-3784
  long   DVTPTR17 3785-3789
  int    DVTOTH17 3790-3793
  int    HHTOTD17 3794-3796
  int    HHAGD17 3797-3799
  long   HHATCH17 3800-3805
  long   HHAEXP17 3806-3811
  long   HHASLF17 3812-3817
  long   HHAMCR17 3818-3822
  long   HHAMCD17 3823-3828
  long   HHAPRV17 3829-3833
  long   HHAVA17 3834-3838
  int    HHATRI17 3839-3842
  int    HHAOFD17 3843-3846
  long   HHASTL17 3847-3852
  byte   HHAWCP17 3853-3853
  long   HHAOPR17 3854-3858
  long   HHAOPU17 3859-3863
  int    HHAOSR17 3864-3867
  long   HHAPTR17 3868-3872
  long   HHAOTH17 3873-3878
  int    HHINDD17 3879-3881
  long   HHNTCH17 3882-3887
  long   HHNEXP17 3888-3893
  long   HHNSLF17 3894-3899
  long   HHNMCD17 3900-3904
  int    HHNMCR17 3905-3908
  int    HHNPRV17 3909-3912
  int    HHNVA17 3913-3916
  byte   HHNTRI17 3917-3917
  byte   HHNOFD17 3918-3918
  int    HHNSTL17 3919-3922
  byte   HHNWCP17 3923-3923
  long   HHNOPR17 3924-3928
  byte   HHNOPU17 3929-3929
  int    HHNOSR17 3930-3933
  int    HHNPTR17 3934-3937
  long   HHNOTH17 3938-3942
  int    HHINFD17 3943-3945
  int    VISEXP17 3946-3949
  int    VISTCH17 3950-3953
  int    VISSLF17 3954-3957
  int    VISMCR17 3958-3960
  int    VISMCD17 3961-3964
  int    VISPRV17 3965-3968
  int    VISVA17 3969-3972
  int    VISTRI17 3973-3975
  int    VISOFD17 3976-3978
  int    VISSTL17 3979-3981
  byte   VISWCP17 3982-3982
  int    VISOPR17 3983-3985
  int    VISOPU17 3986-3988
  int    VISOSR17 3989-3991
  int    VISPTR17 3992-3995
  int    VISOTH17 3996-3998
  long   OTHTCH17 3999-4004
  long   OTHEXP17 4005-4009
  long   OTHSLF17 4010-4014
  long   OTHMCR17 4015-4019
  long   OTHMCD17 4020-4024
  long   OTHPRV17 4025-4029
  int    OTHVA17 4030-4033
  int    OTHTRI17 4034-4037
  int    OTHOFD17 4038-4040
  byte   OTHSTL17 4041-4042
  int    OTHWCP17 4043-4046
  int    OTHOPR17 4047-4050
  int    OTHOPU17 4051-4054
  int    OTHOSR17 4055-4058
  long   OTHPTR17 4059-4063
  int    OTHOTH17 4064-4067
  int    RXTOT17 4068-4070
  long   RXEXP17 4071-4076
  long   RXSLF17 4077-4081
  long   RXMCR17 4082-4087
  long   RXMCD17 4088-4092
  long   RXPRV17 4093-4098
  long   RXVA17 4099-4104
  long   RXTRI17 4105-4109
  long   RXOFD17 4110-4114
  long   RXSTL17 4115-4119
  long   RXWCP17 4120-4124
  long   RXOPR17 4125-4129
  long   RXOPU17 4130-4134
  int    RXOSR17 4135-4138
  long   RXPTR17 4139-4144
  long   RXOTH17 4145-4149
  double PERWT17F 4150-4162
  double FAMWT17F 4163-4174
  double FAMWT17C 4175-4186
  double SAQWT17F 4187-4199
  double DIABW17F 4200-4211
  double CSAQW17F 4212-4223
  int    VARSTR 4224-4227
  byte   VARPSU 4228-4228
using H201.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID17 "FAMILY ID (STUDENT MERGED IN) - 12/31/17";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR17 "RU LETTER AS OF 12/31/17";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE17 "RU SIZE AS OF 12/31/17";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS17 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/17";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE17 "RU SIZE INCLUDING STUDENT AS OF 12/31/17";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION17 "CENSUS REGION AS OF 12/31/17";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS17 "REFERENCE PERSON AS OF 12/31/17";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP17 "1ST RESPONDENT INDICATOR AS OF 12/31/17";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY17 "WAS RESPONDENT A PROXY AS OF 12/31/17";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFM17 "2017 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY17 "2017 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP17 "INSCOPE - R5/3 START THROUGH 12/31/17";
label variable INSC1231 "INSCOPE STATUS ON 12/31/17";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2017";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND17 "ELIGIBILITY STATUS AS OF 12/31/17";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE17X "AGE AS OF 12/31/17 (EDITED/IMPUTED)";
label variable AGELAST "PERSON S AGE LAST TIME ELIGIBLE";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEV1X "RACE (EDITED/IMPUTED)";
label variable RACEV2X "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPNCAT "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY17X "MARITAL STATUS-12/31/17 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID17 "SPOUSE ID - 12/31/17";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN17 "MARITAL STATUS W/SPOUSE PRESENT-12/31/17";
label variable EDUCYR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEG "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU17X "STUDENT STATUS IF AGES 17-23 - 12/31/17";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable HONRDC31 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC42 "HONORABLY DISCHARGED FROM MILITARY";
label variable HONRDC53 "HONORABLY DISCHARGED FROM MILITARY";
label variable REFRL31X "RELATION TO REF PERS R3/1 (EDIT/IMP)";
label variable REFRL42X "RELATION TO REF PERS R4/2 (EDIT/IMP)";
label variable REFRL53X "RELATION TO REF PERS R5/3 (EDIT/IMP)";
label variable REFRL17X "RELATION TO REF PERS 12/31/17 (EDIT/IMP)";
label variable OTHLANG "IN FAMILY WITH SOMEONE SPKNG OTHER LANG";
label variable LANGSPK "LANGUAGE SPOKEN AT HOME OTHER THAN ENGL";
label variable HWELLSPE "HOW WELL PERSON SPEAKS ENGLISH";
label variable BORNUSA "PERSON BORN IN THE US";
label variable YRSINUS "YEARS PERSON LIVED IN THE US";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable HIBPDX "HIGH BLOOD PRESSURE DIAG (>17)";
label variable HIBPAGED "AGE OF DIAGNOSIS-HIGH BLOOD PRESSURE";
label variable BPMLDX "MULT DIAG HIGH BLOOD PRESS (>17)";
label variable CHDDX "CORONARY HRT DISEASE DIAG (>17)";
label variable CHDAGED "AGE OF DIAGNOSIS-CORONARY HEART DISEASE";
label variable ANGIDX "ANGINA DIAGNOSIS (>17)";
label variable ANGIAGED "AGE OF DIAGNOSIS-ANGINA";
label variable MIDX "HEART ATTACK (MI) DIAG (>17)";
label variable MIAGED "AGE OF DIAGNOSIS-HEART ATTACK(MI)";
label variable OHRTDX "OTHER HEART DISEASE DIAG (>17)";
label variable OHRTAGED "AGE OF DIAGNOSIS-OTHER HEART DISEASE";
label variable STRKDX "STROKE DIAGNOSIS (>17)";
label variable STRKAGED "AGE OF DIAGNOSIS-STROKE";
label variable EMPHDX "EMPHYSEMA DIAGNOSIS (>17)";
label variable EMPHAGED "AGE OF DIAGNOSIS-EMPHYSEMA";
label variable CHBRON31 "CHRONC BRONCHITS LAST 12 MTHS (>17)-R3/1";
label variable CHOLDX "HIGH CHOLESTEROL DIAGNOSIS (>17)";
label variable CHOLAGED "AGE OF DIAGNOSIS-HIGH CHOLESTEROL";
label variable CANCERDX "CANCER DIAGNOSIS (>17)";
label variable CABLADDR "CANCER DIAGNOSED - BLADDER (>17)";
label variable CABREAST "CANCER DIAGNOSED - BREAST (>17)";
label variable CACERVIX "CANCER DIAGNOSED - CERVIX (>17)";
label variable CACOLON "CANCER DIAGNOSED - COLON (>17)";
label variable CALUNG "CANCER DIAGNOSED - LUNG (>17)";
label variable CALYMPH "CANCER DIAGNOSED - LYMPHOMA (>17)";
label variable CAMELANO "CANCER DIAGNOSED - MELANOMA (>17)";
label variable CAOTHER "CANCER DIAGNOSED - OTHER (>17)";
label variable CAPROSTA "CANCER DIAGNOSED - PROSTATE (>17)";
label variable CASKINNM "CANCER DIAGNOSED - SKIN-NONMELANO (>17)";
label variable CASKINDK "CANCER DIAGNOSED-SKIN-UNKNOWN TYPE (>17)";
label variable CAUTERUS "CANCER DIAGNOSED - UTERUS (>17)";
label variable DIABDX "DIABETES DIAGNOSIS (>17)";
label variable DIABAGED "AGE OF DIAGNOSIS-DIABETES";
label variable JTPAIN31 "JOINT PAIN LAST 12 MONTHS (>17) - RD 3/1";
label variable ARTHDX "ARTHRITIS DIAGNOSIS (>17)";
label variable ARTHTYPE "TYPE OF ARTHRITIS DIAGNOSED (>17)";
label variable ARTHAGED "AGE OF DIAGNOSIS-ARTHRITIS";
label variable ASTHDX "ASTHMA DIAGNOSIS";
label variable ASTHAGED "AGE OF DIAGNOSIS-ASTHMA";
label variable ASSTIL31 "DOES PERSON STILL HAVE ASTHMA-RD3/1";
label variable ASATAK31 "ASTHMA ATTACK LAST 12 MOS - RD3/1";
label variable ASTHEP31 "WHEN WAS LAST EPISODE OF ASTHMA - RD 3/1";
label variable ADHDADDX "ADHDADD DIAGNOSIS (5-17)";
label variable ADHDAGED "AGE OF DIAGNOSIS-ADHD/ADD";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable DFHEAR42 "SERIOUS DIFFICULTY HEARING-RD 4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable DFSEE42 "SERIOUS DIFFICULTY SEE W/GLASSES-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable DFCOG42 "SERIOUS COGNITIVE DIFFICULTIES-RD 4/2";
label variable DFWLKC42 "SERIOUS DIFCULTY WLK/CLIMB STAIRS-RD 4/2";
label variable DFDRSB42 "DIFFICULTY DRESSING/BATHING-RD 4/2";
label variable DFERND42 "DIFFICULTY DOING ERRANDS ALONE-RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable ANYLMI17 "ANY LIMITATION IN P21R3,4/P22R1,2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHENEC42 "CAHPS:12MOS:EASY GET NEC CARE (0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHEYRE42 "CAHPS:12MOS:ESY W/RFR TO SPEC(0-17)-R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17)-R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PHYEXE53 "MOD/VIG PHYS EXEC 5X WK (>17) - RD 5/3";
label variable OFTSMK53 "HOW OFTN SMOKE CIGARETTES (>17) - RD 5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPROX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL VR-12";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES VR-12";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS VR-12";
label variable ADACLS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS VR-12";
label variable ADWKLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS VR-12";
label variable ADEMLS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS VR-12";
label variable ADMWCF42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS VR-12";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK VR-12";
label variable ADPCFL42 "SAQ 4WKS: FELT CALM/PEACEFUL VR-12";
label variable ADENGY42 "SAQ 4WKS: HAD A LOT OF ENERGY VR-12";
label variable ADPRST42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR VR-12";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV VR-12";
label variable VPCS42 "SAQ:PHY COMPONENT SUMMRY VR-12 IMPUTED";
label variable VMCS42 "SAQ:MNT COMPONENT SUMMRY VR-12 IMPUTED";
label variable VRFLAG42 "SAQ: VPCS42/VMCS42 IMPUTATION FLAG VR-12";
label variable ADNERV42 "SAQ 30 DAYS: HOW OFTEN FELT NERVOUS";
label variable ADHOPE42 "SAQ 30 DAYS: HOW OFTEN FELT HOPELESS";
label variable ADREST42 "SAQ 30 DAYS: HOW OFTEN FELT RESTLESS";
label variable ADSAD42 "SAQ 30 DAYS: HOW OFTEN FELT SAD";
label variable ADEFRT42 "SAQ 30 DAYS: HOW OFTN EVRYTHNG AN EFFORT";
label variable ADWRTH42 "SAQ 30 DAYS: HOW OFTEN FELT WORTHLESS";
label variable K6SUM42 "SAQ 30 DAYS: OVERALL RATING OF FEELINGS";
label variable ADINTR42 "SAQ 2 WKS: LITTLE INTEREST IN THINGS";
label variable ADDPRS42 "SAQ 2 WKS: FELT DOWN/DEPRESSED/HOPELESS";
label variable PHQ242 "SAQ 2 WKS: OVERALL RATING OF FEELINGS";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADINST42 "SAQ 12 MOS: DR GAVE SPCIFC INSTRCTNS";
label variable ADEZUN42 "SAQ 12 MOS: DR GIVEN INSTR. EZ UNDRSTD";
label variable ADTLHW42 "SAQ 12 MOS: DR ASKED R DESC HOW FOLLOW";
label variable ADFFRM42 "SAQ 12 MOS: HAD TO FILL OUT/SIGN FORMS";
label variable ADFHLP42 "SAQ 12 MOS: OFFRD HELP FILLING OUT FORMS";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADSPCL42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADSNSP42 "SAQ 12MOS: HOW ESY TO SEE SPECIALIST";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C IN 2017";
label variable DSFT1853 "DCS: HAD FEET CHECKED DURING 2018";
label variable DSFT1753 "DCS: HAD FEET CHECKED DURING 2017";
label variable DSFT1653 "DCS: HAD FEET CHECKED DURING 2016";
label variable DSFB1653 "DCS: HAD FEET CHECKED BEFORE 2016";
label variable DSFTNV53 "DCS: NEVER HAD FEET CHECKED";
label variable DSEY1853 "DCS: DILATED EYE EXAM IN 2018";
label variable DSEY1753 "DCS: DILATED EYE EXAM IN 2017";
label variable DSEY1653 "DCS: DILATED EYE EXAM IN 2016";
label variable DSEB1653 "DCS: DILATED EYE EXAM BEFORE 2016";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSCH1853 "DCS: BLOOD CHOLESTEROL CHECKED IN 2018";
label variable DSCH1753 "DCS: BLOOD CHOLESTEROL CHECKED IN 2017";
label variable DSCH1653 "DCS: BLOOD CHOLESTEROL CHECKED IN 2016";
label variable DSCB1653 "DCS: BLOOD CHOLESTEROL CHECKED BEF 2016";
label variable DSCHNV53 "DCS: NEVER HAD BLOOD CHOLESTEROL CHECKED";
label variable DSFL1853 "DCS: GOT FLU VACCINATION IN 2018";
label variable DSFL1753 "DCS: GOT FLU VACCINATION IN 2017";
label variable DSFL1653 "DCS: GOT FLU VACCINATION IN 2016";
label variable DSVB1653 "DCS: GOT FLU VACCINATION BEFORE 2016";
label variable DSFLNV53 "DCS: NEVER GOT FLU VACCINATION";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSCPCP53 "DCS: LEARNED CARE FROM PRIMARY CARE PROV";
label variable DSCNPC53 "DCS: LEARNED CARE FROM OTHER PROVIDER";
label variable DSCPHN53 "DCS: LEARN CARE FROM PHONE CALL W/PROV";
label variable DSCINT53 "DCS: LEARNED CARE FROM READING INTERNET";
label variable DSCGRP53 "DCS: LEARNED CARE BY TAKING GROUP CLASS";
label variable DSCONF53 "DCS: CONFIDENT TAKING CARE OF DIABETES";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable CCNRDI31 "CSAQ: CANCER DIAGNOSIS BY HEALTH PROF";
label variable CDIAG31 "CSAQ: CANCER DIAGNOSIS BEFORE AGE 18";
label variable CTRTMT31 "CSAQ: CURRENTLY TREATED FOR CANCER";
label variable CLSTRT31 "CSAQ: LAST CANCER TREATMENT";
label variable CBCK31 "CSAQ: CANCER BACK TOLD BY HEALTH PROF";
label variable CBCKYR31 "CSAQ: YEAR TOLD CANCER BACK";
label variable CFTRT31 "CSAQ: FIRST TIME TREATED FOR CANCER";
label variable CWRKP31 "CSAQ: WORK FOR PAY SINCE DIAGNOSED";
label variable CTMOFF31 "CSAQ: TAKE TIME OFF SINCE DIAGNOSED";
label variable CWYCNG31 "CSAQ: WHY MAKE WORK CHANGES";
label variable CEXTM31 "CSAQ: TAKE PAID TIME OFF";
label variable CEXTDI31 "CSAQ: PAID TIME OFF AT DIAGNOSIS";
label variable CEXTRT31 "CSAQ: PAID TIME OFF DURING TREATMENT";
label variable CEXTLT31 "CSAQ: PAID TIME OFF <1 YEAR AFT TRTMNT";
label variable CEXTMT31 "CSAQ: PAID TIME OFF >=1 YEAR AFT TRTMNT";
label variable CNPTLD31 "CSAQ: CHNGE PART TIME OR LESS DEMAND JOB";
label variable CNGFLX31 "CSAQ: FLEXIBLE WORK SCHEDULE";
label variable CPROM31 "CSAQ: DID NOT PURSUE PROMOTION";
label variable CERET31 "CSAQ: EARLY RETIREMENT";
label variable CPTASK31 "CSAQ: INTERFERE WITH PHYSICAL TASKS";
label variable CMTASK31 "CSAQ: INTERFERE WITH MENTAL TASKS";
label variable CLPROD31 "CSAQ: FEEL LESS PRODUCTIVE";
label variable CFRET31 "CSAQ: MIGHT BE FORCED TO RETIRE";
label variable CLHINS31 "CSAQ: STAY AT JOB-WORRY LOSE HLTH INS";
label variable CCLHIN31 "CSAQ: CONCERNED LOSING HLTH INS TO CNCR";
label variable CSLHIN31 "CSAQ: FMEM STAY AT JOB-WORRY LOSE INS";
label variable CFMEM31 "CSAQ: FMEM PROVIDE CARE";
label variable CFMSPS31 "CSAQ: FMEM SPOUSE PROVIDED CARE";
label variable CFMCHD31 "CSAQ: FMEM CHILD PROVIDED CARE";
label variable CFMSIB31 "CSAQ: FMEM SIBLING PROVIDED CARE";
label variable CFMPAR31 "CSAQ: FMEM PARENT PROVIDED CARE";
label variable CFMREL31 "CSAQ: FMEM OTH RELATIVE PROVIDED CARE";
label variable CFMFND31 "CSAQ: FMEM FRIEND PROVIDED CARE";
label variable CFMOTR31 "CSAQ: FMEM OTHER PROVIDED CARE";
label variable CFMTOF31 "CSAQ: FMEM TAKE EXTENDED TIME OFF";
label variable CFM2MT31 "CSAQ: FMEM TAKE EXTND TIM OFF >= 2 MNTH";
label variable CINCOV31 "CSAQ: COVERED BY HEALTH INSURANCE";
label variable CINPRV31 "CSAQ: COVERED BY PRIVATE HLTH INS";
label variable CINMDC31 "CSAQ: COVERED BY MEDICARE HLTH INS";
label variable CINMDG31 "CSAQ: COVERED BY MEDI-GAP HLTH INS";
label variable CINMDA31 "CSAQ: COVERED BY MEDICAID HLTH INS";
label variable CINMLT31 "CSAQ: COVERED BY MILITARY HLTH INS";
label variable CINIHS31 "CSAQ: COVERED BY I.H.S. HLTH INS";
label variable CINSHP31 "CSAQ: COVERED BY STATE HLTH INS";
label variable CINOGP31 "CSAQ: COVERED BY OTH GOVT HLTH INS";
label variable CINSSP31 "CSAQ: COVERED BY SINGLE SERV HLTH INS";
label variable CINNCV31 "CSAQ: COVERED BY NO HLTH INS";
label variable CINNOC31 "CSAQ: HLTH INS REFUSED TO COVER CARE";
label variable CINADQ31 "CSAQ: HLTH INS COVERAGE NOT ADEQUATE";
label variable CINCMP31 "CSAQ: CURRENT HLTH INS COMPARE";
label variable CINDIF31 "CSAQ: DIFFICULTY FINDING HLTH INS";
label variable CINAFD31 "CSAQ: DIFFICULTY AFFORDING HLTH INS";
label variable CNCMED31 "CSAQ: UNCOVERED MEDICAL EXPENSES";
label variable CNCTRP31 "CSAQ: UNCOVERED TRANSPORTATION EXPENSES";
label variable CNCLOD31 "CSAQ: UNCOVERED LODGING EXPENSES";
label variable CNCCHD31 "CSAQ: UNCOVERED CHILD CARE EXPENSES";
label variable CNCHME31 "CSAQ: UNCOVERED HOME CARE EXPENSES";
label variable CNCNON31 "CSAQ: NO UNCOVERED EXPENSES";
label variable CNCNTS31 "CSAQ: NOT SURE IF UNCOVERED EXPENSES";
label variable CFNDBT31 "CSAQ: MONEY BORROWED OR IN DEBT";
label variable CFNAMT31 "CSAQ: AMOUNT OF BORROWED OR IN DEBT";
label variable CFNVAC31 "CSAQ: SACRIFICED LEISURE SPENDING";
label variable CFNPUR31 "CSAQ: SACRIFICED BIG PURCHASES";
label variable CFNSPD31 "CSAQ: SACRIFICED BASIC SPENDING";
label variable CFNSAV31 "CSAQ: SACRIFICED SAVINGS";
label variable CFNLIV31 "CSAQ: SACRIFICED LIVING SITUATION";
label variable CFNOTH31 "CSAQ: SACRIFICED OTHER COST";
label variable CFNUNB31 "CSAQ: UNABLE TO COVER MEDICAL BILLS";
label variable CFNBNK31 "CSAQ: SELF OR FMEM FILE BANKRUPTCY";
label variable CFNPMT31 "CSAQ: WORRY PAY MEDICAL BILLS";
label variable CFNSTB31 "CSAQ: WORRY FAMILY FINANCIAL STABILITY";
label variable CFNINC31 "CSAQ: WORRY INCOME STABILITY";
label variable CMCFUP31 "CSAQ: DISCUSS REGULAR FOLL-UP CARE";
label variable CMCEFF31 "CSAQ: DISCUSS SIDE EFFECTS";
label variable CMCPSY31 "CSAQ: DISCUSS EMO/SOC NEEDS";
label variable CMCSTY31 "CSAQ: DISCUSS LIFESTYLE OR HEALTH";
label variable CMCOST31 "CSAQ: DISCUSS COSTS FOR CANCER CARE";
label variable CMCTRT31 "CSAQ: DISCUSS CANCER TREATMENTS";
label variable CDLPRS31 "CSAQ: DLY OR FOREGO PRESCRIPTION";
label variable CDLVST31 "CSAQ: DLY OR FOREGO VISIT SPECIALIST";
label variable CDLTRT31 "CSAQ: DLY OR FOREGO TREATMENT";
label variable CDLFUP31 "CSAQ: DLY OR FOREGO FOLLOW UP CARE";
label variable CDLMNT31 "CSAQ: DLY OR FOREGO MENTAL HEALTH SRVCS";
label variable CDLOTH31 "CSAQ: DLY OR FOREGO OTHER";
label variable CMCNEC31 "CSAQ: RECEIVED NECESSARY MEDICAL CARE";
label variable CMNAFF31 "CSAQ: COULD NOT AFFORD CARE";
label variable CMNINS31 "CSAQ: INS COMPANY DIDN T APPROVE OR PAY";
label variable CMNACC31 "CSAQ: DOCTOR DID NOT ACCEPT INSURANCE";
label variable CMNOFF31 "CSAQ: PROBLEMS GETTING TO DOCTOR OFFICE";
label variable CMNTIM31 "CSAQ: NO TIME OFF FROM WORK";
label variable CMNPLC31 "CSAQ: DIDN T KNOW WHERE TO GO";
label variable CMNCRE31 "CSAQ: NO CHILD/ADULT CARE";
label variable CMNLNG31 "CSAQ: NO TIME FOR CARE/TREATMENT";
label variable CEFACT31 "CSAQ: ACTIVITIES LIMITED DUE TO CANCER";
label variable CEFLCT31 "CSAQ: HOW LONG ACTIVITIES LIMITED";
label variable CEFOG31 "CSAQ: IS LIMITATION ONGOING";
label variable CEFMTL31 "CSAQ: MENTAL TASKS AFFECTED BY CANCER";
label variable CEFUND31 "CSAQ: UNDSTNDING INSRNCE/MEDICAL BILL";
label variable CEFBCK31 "CSAQ: WORRY CANCER COME BACK/GET WORSE";
label variable CEFSTG31 "CSAQ: EXP-MADE A STRONGER PERSON";
label variable CEFCOP31 "CSAQ: EXP-COPE BETTER W/ CHALLENGES";
label variable CEFPOS31 "CSAQ: EXP-REASON FOR POSITIVE CHANGES";
label variable CEFHLT31 "CSAQ: EXP-MADE HEALTHIER HABITS";
label variable CEFPHL31 "CSAQ: RATE PHYSICAL HEALTH";
label variable CEFPAC31 "CSAQ: RATE PHYSICAL ACTIVITY EXTENT";
label variable CEFPIN31 "CSAQ: RATE AVERAGE PAIN IN 7 DAYS";
label variable CEFFTG31 "CSAQ: RATE AVERAGE FATIGUE IN 7 DAYS";
label variable CEFQLF31 "CSAQ: RATE QUALITY OF LIFE";
label variable CEFMHL31 "CSAQ: RATE MENTAL HEALTH";
label variable CEFRLT31 "CSAQ: RATE SOCIAL ACTIVITY/RELATIONSHIP";
label variable CEFMPR31 "CSAQ: RATE EMOTIONAL PROBLEM IN 7 DAYS";
label variable DDNWRK17 "# DAYS MISSED WORK DUE TO ILL/INJ 2017";
label variable OTHDYS17 "MISS ANY WORK DAY TO CARE FOR OTH 2017";
label variable OTHNDD17 "# DAY MISSED WORK TO CARE FOR OTH 2017";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable NOHINS42 "AC08 OTH REAS NO USC:NO HLTH INSRNC-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable HEALTH42 "AC08 OTH REAS NO USC: HLTH RELATED-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable CLINIC42 "AC08 OTH REAS NO USC: HOSP/ER/CLNIC-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable PRVSPK42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/17";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable NHRWG31 "UPDATED HRLY WAGE RD 3/1 CMJ (EDITED)";
label variable NHRWG42 "UPDATED HRLY WAGE RD 4/2 CMJ (EDITED)";
label variable NHRWG53 "UPDATED HRLY WAGE RD 5/3 CMJ (EDITED)";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable EMPST31H "EMPLOYMENT STATUS RD 3/1 (IMP)";
label variable EMPST42H "EMPLOYMENT STATUS RD 4/2 (IMP)";
label variable EMPST53H "EMPLOYMENT STATUS RD 5/3 (IMP)";
label variable SLFCM31H "SELF-EMPLOYED AT RD 3/1 CMJ (IMP)";
label variable SLFCM42H "SELF-EMPLOYED AT RD 4/2 CMJ (IMP)";
label variable SLFCM53H "SELF-EMPLOYED AT RD 5/3 CMJ (IMP)";
label variable NMEMP31H "NUMBER OF EMPLOYEES AT RD 3/1 CMJ (IMP)";
label variable NMEMP42H "NUMBER OF EMPLOYEES AT RD 4/2 CMJ (IMP)";
label variable NMEMP53H "NUMBER OF EMPLOYEES AT RD 5/3 CMJ (IMP)";
label variable MORE31H "RD 3/1 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable MORE42H "RD 4/2 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable MORE53H "RD 5/3 CMJ FIRM MORE THAN 1 LOCAT (IMP)";
label variable INDCT31H "INDUSTRY GROUP RD 3/1 CMJ (IMP)";
label variable INDCT42H "INDUSTRY GROUP RD 4/2 CMJ (IMP)";
label variable INDCT53H "INDUSTRY GROUP RD 5/3 CMJ (IMP)";
label variable OCCCT31H "OCCUPATION GROUP RD 3/1 CMJ (IMP)";
label variable OCCCT42H "OCCUPATION GROUP RD 4/2 CMJ (IMP)";
label variable OCCCT53H "OCCUPATION GROUP RD 5/3 CMJ (IMP)";
label variable HOUR31H "HOURS PER WEEK AT RD 3/1 CMJ (IMP)";
label variable HOUR42H "HOURS PER WEEK AT RD 4/2 CMJ (IMP)";
label variable HOUR53H "HOURS PER WEEK AT RD 5/3 CMJ (IMP)";
label variable JBORG31H "PRV, ST-LC GOV, FED GOV RD 3/1 CMJ (IMP)";
label variable JBORG42H "PRV, ST-LC GOV, FED GOV RD 4/2 CMJ (IMP)";
label variable JBORG53H "PRV, ST-LC GOV, FED GOV RD 5/3 CMJ (IMP)";
label variable UNION31H "UNION STATUS AT RD 3/1 CMJ (IMP)";
label variable UNION42H "UNION STATUS AT RD 4/2 CMJ (IMP)";
label variable UNION53H "UNION STATUS AT RD 5/3 CMJ (IMP)";
label variable BSNTY31H "SOL PROP, PRTNR, CORP, RD 3/1 CMJ (IMP)";
label variable BSNTY42H "SOL PROP, PRTNR, CORP, RD 4/2 CMJ (IMP)";
label variable BSNTY53H "SOL PROP, PRTNR, CORP, RD 5/3 CMJ (IMP)";
label variable HRWG31H "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42H "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53H "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable CMJHLD31 "HLTH INSUR HELD FROM RD 3/1 CMJ (PRPL)";
label variable CMJHLD42 "HLTH INSUR HELD FROM RD 4/2 CMJ (PRPL)";
label variable CMJHLD53 "HLTH INSUR HELD FROM RD 5/3 CMJ (PRPL)";
label variable OFFER31H "HEALTH INSUR OFFERED BY RD 3/1 CMJ (IMP)";
label variable OFFER42H "HEALTH INSUR OFFERED BY RD 4/2 CMJ (IMP)";
label variable OFFER53H "HEALTH INSUR OFFERED BY RD 5/3 CMJ (IMP)";
label variable OFEMP31H "EMP OFFERS HEALTH INS RD 3/1 CMJ (IMP)";
label variable OFEMP42H "EMP OFFERS HEALTH INS RD 4/2 CMJ (IMP)";
label variable OFEMP53H "EMP OFFERS HEALTH INS RD 5/3 CMJ (IMP)";
label variable PYVAC31H "PAID VACATION AT RD 3/1 CMJ (IMP)";
label variable PYVAC42H "PAID VACATION AT RD 4/2 CMJ (IMP)";
label variable PYVAC53H "PAID VACATION AT RD 5/3 CMJ (IMP)";
label variable SCPAY31H "PAID SICK LEAVE AT RD 3/1 CMJ (IMP)";
label variable SCPAY42H "PAID SICK LEAVE AT RD 4/2 CMJ (IMP)";
label variable SCPAY53H "PAID SICK LEAVE AT RD 5/3 CMJ (IMP)";
label variable PAYDR31H "PAID LEAVE TO VISIT DR RD 3/1 CMJ (IMP)";
label variable PAYDR42H "PAID LEAVE TO VISIT DR RD 4/2 CMJ (IMP)";
label variable PAYDR53H "PAID LEAVE TO VISIT DR RD 5/3 CMJ (IMP)";
label variable RTPLN31H "PENSION PLAN AT RD 3/1 CMJ (IMP)";
label variable RTPLN42H "PENSION PLAN AT RD 4/2 CMJ (IMP)";
label variable RTPLN53H "PENSION PLAN AT RD 5/3 CMJ (IMP)";
label variable FILEDR17 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL17 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT17 "PERSON S FILING STATUS";
label variable FILER17 "PRIMARY OR SECONDARY FILER";
label variable JTINRU17 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID17 "PID OF SECONDARY FILER";
label variable TAXFRM17 "TAX FORM PERSON WILL FILE";
label variable FOODST17 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN17 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODVL17 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP17X "PERSON S TOTAL INCOME";
label variable FAMINC17 "FAMILY S TOTAL INCOME";
label variable POVCAT17 "FAMILY INC AS % OF POVERTY LINE - CATEGO";
label variable POVLEV17 "FAMILY INC AS % OF POVERTY LINE - CONTIN";
label variable WAGEP17X "PERSON S WAGE INCOME";
label variable WAGIMP17 "WAGE IMPUTATION FLAG";
label variable BUSNP17X "PERSON S BUSINESS INCOME";
label variable BUSIMP17 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP17X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP17 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP17X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP17 "WORKERS  COMP IMPUTATION FLAG";
label variable INTRP17X "PERSON S INTEREST INCOME";
label variable INTIMP17 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP17X "PERSON S DIVIDEND INCOME";
label variable DIVIMP17 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP17X "PERSON S SALES INCOME";
label variable SALIMP17 "SALES INCOME IMPUTATION FLAG";
label variable PENSP17X "PERSON S PENSION INCOME";
label variable PENIMP17 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP17X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP17 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP17X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP17 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP17X "PERSON S VETERAN S INCOME";
label variable VETIMP17 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP17X "PERSON S IRA INCOME";
label variable IRAIMP17 "IRA INCOME IMPUTATION FLAG";
label variable ALIMP17X "PERSON S ALIMONY INCOME";
label variable ALIIMP17 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP17X "PERSON S CHILD SUPPORT";
label variable CHLIMP17 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP17X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP17 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP17X "PERSON S SSI";
label variable SSIIMP17 "SSI IMPUTATION FLAG";
label variable PUBP17X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP17 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP17X "PERSON S OTHER INCOME";
label variable OTHIMP17 "OTHER INCOME IMPUTATION FLAG";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable TRIJA17X "COVERED BY TRICARE/CHAMPVA IN JAN17 (ED)";
label variable TRIFE17X "COVERED BY TRICARE/CHAMPVA IN FEB17 (ED)";
label variable TRIMA17X "COVERED BY TRICARE/CHAMPVA IN MAR17 (ED)";
label variable TRIAP17X "COVERED BY TRICARE/CHAMPVA IN APR17(ED)";
label variable TRIMY17X "COVERED BY TRICARE/CHAMPVA IN MAY17 (ED)";
label variable TRIJU17X "COVERED BY TRICARE/CHAMPVA IN JUN17 (ED)";
label variable TRIJL17X "COVERED BY TRICARE/CHAMPVA IN JUL17 (ED)";
label variable TRIAU17X "COVERED BY TRICARE/CHAMPVA IN AUG17 (ED)";
label variable TRISE17X "COVERED BY TRICARE/CHAMPVA IN SEP17 (ED)";
label variable TRIOC17X "COVERED BY TRICARE/CHAMPVA IN OCT17 (ED)";
label variable TRINO17X "COVERED BY TRICARE/CHAMPVA IN NOV17 (ED)";
label variable TRIDE17X "COVERED BY TRICARE/CHAMPVA IN DEC17 (ED)";
label variable MCRJA17 "COVERED BY MEDICARE IN JAN17";
label variable MCRFE17 "COVERED BY MEDICARE IN FEB17";
label variable MCRMA17 "COVERED BY MEDICARE IN MAR17";
label variable MCRAP17 "COVERED BY MEDICARE IN APR17";
label variable MCRMY17 "COVERED BY MEDICARE IN MAY17";
label variable MCRJU17 "COVERED BY MEDICARE IN JUN17";
label variable MCRJL17 "COVERED BY MEDICARE IN JUL17";
label variable MCRAU17 "COVERED BY MEDICARE IN AUG17";
label variable MCRSE17 "COVERED BY MEDICARE IN SEP17";
label variable MCROC17 "COVERED BY MEDICARE IN OCT17";
label variable MCRNO17 "COVERED BY MEDICARE IN NOV17";
label variable MCRDE17 "COVERED BY MEDICARE IN DEC17";
label variable MCRJA17X "COVERED BY MEDICARE IN JAN17 (ED)";
label variable MCRFE17X "COVERED BY MEDICARE IN FEB17 (ED)";
label variable MCRMA17X "COVERED BY MEDICARE IN MAR17 (ED)";
label variable MCRAP17X "COVERED BY MEDICARE IN APR17 (ED)";
label variable MCRMY17X "COVERED BY MEDICARE IN MAY17 (ED)";
label variable MCRJU17X "COVERED BY MEDICARE IN JUN17 (ED)";
label variable MCRJL17X "COVERED BY MEDICARE IN JUL17 (ED)";
label variable MCRAU17X "COVERED BY MEDICARE IN AUG17 (ED)";
label variable MCRSE17X "COVERED BY MEDICARE IN SEP17 (ED)";
label variable MCROC17X "COVERED BY MEDICARE IN OCT17 (ED)";
label variable MCRNO17X "COVERED BY MEDICARE IN NOV17 (ED)";
label variable MCRDE17X "COVERED BY MEDICARE IN DEC17 (ED)";
label variable MCDJA17 "COV BY MEDICAID OR SCHIP IN JAN17";
label variable MCDFE17 "COV BY MEDICAID OR SCHIP IN FEB17";
label variable MCDMA17 "COV BY MEDICAID OR SCHIP IN MAR17";
label variable MCDAP17 "COV BY MEDICAID OR SCHIP IN APR17";
label variable MCDMY17 "COV BY MEDICAID OR SCHIP IN MAY17";
label variable MCDJU17 "COV BY MEDICAID OR SCHIP IN JUN17";
label variable MCDJL17 "COV BY MEDICAID OR SCHIP IN JUL17";
label variable MCDAU17 "COV BY MEDICAID OR SCHIP IN AUG17";
label variable MCDSE17 "COV BY MEDICAID OR SCHIP IN SEP17";
label variable MCDOC17 "COV BY MEDICAID OR SCHIP IN OCT17";
label variable MCDNO17 "COV BY MEDICAID OR SCHIP IN NOV17";
label variable MCDDE17 "COV BY MEDICAID OR SCHIP IN DEC17";
label variable MCDJA17X "COV BY MEDICAID OR SCHIP IN JAN17 (ED)";
label variable MCDFE17X "COV BY MEDICAID OR SCHIP IN FEB17 (ED)";
label variable MCDMA17X "COV BY MEDICAID OR SCHIP IN MAR17 (ED)";
label variable MCDAP17X "COV BY MEDICAID OR SCHIP IN APR17 (ED)";
label variable MCDMY17X "COV BY MEDICAID OR SCHIP IN MAY17 (ED)";
label variable MCDJU17X "COV BY MEDICAID OR SCHIP IN JUN17 (ED)";
label variable MCDJL17X "COV BY MEDICAID OR SCHIP IN JUL17 (ED)";
label variable MCDAU17X "COV BY MEDICAID OR SCHIP IN AUG17 (ED)";
label variable MCDSE17X "COV BY MEDICAID OR SCHIP IN SEP17 (ED)";
label variable MCDOC17X "COV BY MEDICAID OR SCHIP IN OCT17 (ED)";
label variable MCDNO17X "COV BY MEDICAID OR SCHIP IN NOV17 (ED)";
label variable MCDDE17X "COV BY MEDICAID OR SCHIP IN DEC17 (ED)";
label variable OPAJA17 "COV BY OTHER PUBLIC A INS IN JAN17";
label variable OPAFE17 "COV BY OTHER PUBLIC A INS IN FEB17";
label variable OPAMA17 "COV BY OTHER PUBLIC A INS IN MAR17";
label variable OPAAP17 "COV BY OTHER PUBLIC A INS IN APR17";
label variable OPAMY17 "COV BY OTHER PUBLIC A INS IN MAY17";
label variable OPAJU17 "COV BY OTHER PUBLIC A INS IN JUN17";
label variable OPAJL17 "COV BY OTHER PUBLIC A INS IN JUL17";
label variable OPAAU17 "COV BY OTHER PUBLIC A INS IN AUG17";
label variable OPASE17 "COV BY OTHER PUBLIC A INS IN SEP17";
label variable OPAOC17 "COV BY OTHER PUBLIC A INS IN OCT17";
label variable OPANO17 "COV BY OTHER PUBLIC A INS IN NOV17";
label variable OPADE17 "COV BY OTHER PUBLIC A INS IN DEC17";
label variable OPBJA17 "COV BY OTHER PUBLIC B INS IN JAN17";
label variable OPBFE17 "COV BY OTHER PUBLIC B INS IN FEB17";
label variable OPBMA17 "COV BY OTHER PUBLIC B INS IN MAR17";
label variable OPBAP17 "COV BY OTHER PUBLIC B INS IN APR17";
label variable OPBMY17 "COV BY OTHER PUBLIC B INS IN MAY17";
label variable OPBJU17 "COV BY OTHER PUBLIC B INS IN JUN17";
label variable OPBJL17 "COV BY OTHER PUBLIC B INS IN JUL17";
label variable OPBAU17 "COV BY OTHER PUBLIC B INS IN AUG17";
label variable OPBSE17 "COV BY OTHER PUBLIC B INS IN SEP17";
label variable OPBOC17 "COV BY OTHER PUBLIC B INS IN OCT17";
label variable OPBNO17 "COV BY OTHER PUBLIC B INS IN NOV17";
label variable OPBDE17 "COV BY OTHER PUBLIC B INS IN DEC17";
label variable PUBJA17X "COVR BY ANY PUBLIC INS IN JAN17 (ED)";
label variable PUBFE17X "COVR BY ANY PUBLIC INS IN FEB17 (ED)";
label variable PUBMA17X "COVR BY ANY PUBLIC INS IN MAR17 (ED)";
label variable PUBAP17X "COVR BY ANY PUBLIC INS IN APR17 (ED)";
label variable PUBMY17X "COVR BY ANY PUBLIC INS IN MAY17 (ED)";
label variable PUBJU17X "COVR BY ANY PUBLIC INS IN JUN17 (ED)";
label variable PUBJL17X "COVR BY ANY PUBLIC INS IN JUL17 (ED)";
label variable PUBAU17X "COVR BY ANY PUBLIC INS IN AUG17 (ED)";
label variable PUBSE17X "COVR BY ANY PUBLIC INS IN SEP17 (ED)";
label variable PUBOC17X "COVR BY ANY PUBLIC INS IN OCT17 (ED)";
label variable PUBNO17X "COVR BY ANY PUBLIC INS IN NOV17 (ED)";
label variable PUBDE17X "COVR BY ANY PUBLIC INS IN DEC17 (ED)";
label variable PEGJA17 "COVERED BY EMPL UNION INS IN JAN17";
label variable PEGFE17 "COVERED BY EMPL UNION INS IN FEB17";
label variable PEGMA17 "COVERED BY EMPL UNION INS IN MAR17";
label variable PEGAP17 "COVERED BY EMPL UNION INS IN APR17";
label variable PEGMY17 "COVERED BY EMPL UNION INS IN MAY17";
label variable PEGJU17 "COVERED BY EMPL UNION INS IN JUN17";
label variable PEGJL17 "COVERED BY EMPL UNION INS IN JUL17";
label variable PEGAU17 "COVERED BY EMPL UNION INS IN AUG17";
label variable PEGSE17 "COVERED BY EMPL UNION INS IN SEP17";
label variable PEGOC17 "COVERED BY EMPL UNION INS IN OCT17";
label variable PEGNO17 "COVERED BY EMPL UNION INS IN NOV17";
label variable PEGDE17 "COVERED BY EMPL UNION INS IN DEC17";
label variable PDKJA17 "COVR BY PRIV INS (SOURCE UNKNWN) JAN17";
label variable PDKFE17 "COVR BY PRIV INS (SOURCE UNKNWN) FEB17";
label variable PDKMA17 "COVR BY PRIV INS (SOURCE UNKNWN) MAR17";
label variable PDKAP17 "COVR BY PRIV INS (SOURCE UNKNWN) APR17";
label variable PDKMY17 "COVR BY PRIV INS (SOURCE UNKNWN) MAY17";
label variable PDKJU17 "COVR BY PRIV INS (SOURCE UNKNWN) JUN17";
label variable PDKJL17 "COVR BY PRIV INS (SOURCE UNKNWN) JUL17";
label variable PDKAU17 "COVR BY PRIV INS (SOURCE UNKNWN) AUG17";
label variable PDKSE17 "COVR BY PRIV INS (SOURCE UNKNWN) SEP17";
label variable PDKOC17 "COVR BY PRIV INS (SOURCE UNKNWN) OCT17";
label variable PDKNO17 "COVR BY PRIV INS (SOURCE UNKNWN) NOV17";
label variable PDKDE17 "COVR BY PRIV INS (SOURCE UNKNWN) DEC17";
label variable PNGJA17 "COVERED BY NONGROUP INS IN JAN17";
label variable PNGFE17 "COVERED BY NONGROUP INS IN FEB17";
label variable PNGMA17 "COVERED BY NONGROUP INS IN MAR17";
label variable PNGAP17 "COVERED BY NONGROUP INS IN APR17";
label variable PNGMY17 "COVERED BY NONGROUP INS IN MAY17";
label variable PNGJU17 "COVERED BY NONGROUP INS IN JUN17";
label variable PNGJL17 "COVERED BY NONGROUP INS IN JUL17";
label variable PNGAU17 "COVERED BY NONGROUP INS IN AUG17";
label variable PNGSE17 "COVERED BY NONGROUP INS IN SEP17";
label variable PNGOC17 "COVERED BY NONGROUP INS IN OCT17";
label variable PNGNO17 "COVERED BY NONGROUP INS IN NOV17";
label variable PNGDE17 "COVERED BY NONGROUP INS IN DEC17";
label variable POGJA17 "COVERED BY OTHER GROUP INS IN JAN17";
label variable POGFE17 "COVERED BY OTHER GROUP INS IN FEB17";
label variable POGMA17 "COVERED BY OTHER GROUP INS IN MAR17";
label variable POGAP17 "COVERED BY OTHER GROUP INS IN APR17";
label variable POGMY17 "COVERED BY OTHER GROUP INS IN MAY17";
label variable POGJU17 "COVERED BY OTHER GROUP INS IN JUN17";
label variable POGJL17 "COVERED BY OTHER GROUP INS IN JUL17";
label variable POGAU17 "COVERED BY OTHER GROUP INS IN AUG17";
label variable POGSE17 "COVERED BY OTHER GROUP INS IN SEP17";
label variable POGOC17 "COVERED BY OTHER GROUP INS IN OCT17";
label variable POGNO17 "COVERED BY OTHER GROUP INS IN NOV17";
label variable POGDE17 "COVERED BY OTHER GROUP INS IN DEC17";
label variable PRSJA17 "COVERED BY SELF-EMP-1 INS IN JAN17";
label variable PRSFE17 "COVERED BY SELF-EMP-1 INS IN FEB17";
label variable PRSMA17 "COVERED BY SELF-EMP-1 INS IN MAR17";
label variable PRSAP17 "COVERED BY SELF-EMP-1 INS IN APR17";
label variable PRSMY17 "COVERED BY SELF-EMP-1 INS IN MAY17";
label variable PRSJU17 "COVERED BY SELF-EMP-1 INS IN JUN17";
label variable PRSJL17 "COVERED BY SELF-EMP-1 INS IN JUL17";
label variable PRSAU17 "COVERED BY SELF-EMP-1 INS IN AUG17";
label variable PRSSE17 "COVERED BY SELF-EMP-1 INS IN SEP17";
label variable PRSOC17 "COVERED BY SELF-EMP-1 INS IN OCT17";
label variable PRSNO17 "COVERED BY SELF-EMP-1 INS IN NOV17";
label variable PRSDE17 "COVERED BY SELF-EMP-1 INS IN DEC17";
label variable POUJA17 "COVERED BY HOLDER OUTSIDE OF RU IN JAN17";
label variable POUFE17 "COVERED BY HOLDER OUTSIDE OF RU IN FEB17";
label variable POUMA17 "COVERED BY HOLDER OUTSIDE OF RU IN MAR17";
label variable POUAP17 "COVERED BY HOLDER OUTSIDE OF RU IN APR17";
label variable POUMY17 "COVERED BY HOLDER OUTSIDE OF RU IN MAY17";
label variable POUJU17 "COVERED BY HOLDER OUTSIDE OF RU IN JUN17";
label variable POUJL17 "COVERED BY HOLDER OUTSIDE OF RU IN JUL17";
label variable POUAU17 "COVERED BY HOLDER OUTSIDE OF RU IN AUG17";
label variable POUSE17 "COVERED BY HOLDER OUTSIDE OF RU IN SEP17";
label variable POUOC17 "COVERED BY HOLDER OUTSIDE OF RU IN OCT17";
label variable POUNO17 "COVERED BY HOLDER OUTSIDE OF RU IN NOV17";
label variable POUDE17 "COVERED BY HOLDER OUTSIDE OF RU IN DEC17";
label variable PRXJA17 "COV BY PRIV INS THROUGH EXCHNG IN JAN17";
label variable PRXFE17 "COV BY PRIV INS THROUGH EXCHNG IN FEB17";
label variable PRXMA17 "COV BY PRIV INS THROUGH EXCHNG IN MAR17";
label variable PRXAP17 "COV BY PRIV INS THROUGH EXCHNG IN APR17";
label variable PRXMY17 "COV BY PRIV INS THROUGH EXCHNG IN MAY17";
label variable PRXJU17 "COV BY PRIV INS THROUGH EXCHNG IN JUN17";
label variable PRXJL17 "COV BY PRIV INS THROUGH EXCHNG IN JUL17";
label variable PRXAU17 "COV BY PRIV INS THROUGH EXCHNG IN AUG17";
label variable PRXSE17 "COV BY PRIV INS THROUGH EXCHNG IN SEP17";
label variable PRXOC17 "COV BY PRIV INS THROUGH EXCHNG IN OCT17";
label variable PRXNO17 "COV BY PRIV INS THROUGH EXCHNG IN NOV17";
label variable PRXDE17 "COV BY PRIV INS THROUGH EXCHNG IN DEC17";
label variable PRIJA17 "COVERED BY PRIVATE INS IN JAN17";
label variable PRIFE17 "COVERED BY PRIVATE INS IN FEB17";
label variable PRIMA17 "COVERED BY PRIVATE INS IN MAR17";
label variable PRIAP17 "COVERED BY PRIVATE INS IN APR17";
label variable PRIMY17 "COVERED BY PRIVATE INS IN MAY17";
label variable PRIJU17 "COVERED BY PRIVATE INS IN JUN17";
label variable PRIJL17 "COVERED BY PRIVATE INS IN JUL17";
label variable PRIAU17 "COVERED BY PRIVATE INS IN AUG17";
label variable PRISE17 "COVERED BY PRIVATE INS IN SEP17";
label variable PRIOC17 "COVERED BY PRIVATE INS IN OCT17";
label variable PRINO17 "COVERED BY PRIVATE INS IN NOV17";
label variable PRIDE17 "COVERED BY PRIVATE INS IN DEC17";
label variable HPEJA17 "HOLDER OF EMPL UNION INS IN JAN17";
label variable HPEFE17 "HOLDER OF EMPL UNION INS IN FEB17";
label variable HPEMA17 "HOLDER OF EMPL UNION INS IN MAR17";
label variable HPEAP17 "HOLDER OF EMPL UNION INS IN APR17";
label variable HPEMY17 "HOLDER OF EMPL UNION INS IN MAY17";
label variable HPEJU17 "HOLDER OF EMPL UNION INS IN JUN17";
label variable HPEJL17 "HOLDER OF EMPL UNION INS IN JUL17";
label variable HPEAU17 "HOLDER OF EMPL UNION INS IN AUG17";
label variable HPESE17 "HOLDER OF EMPL UNION INS IN SEP17";
label variable HPEOC17 "HOLDER OF EMPL UNION INS IN OCT17";
label variable HPENO17 "HOLDER OF EMPL UNION INS IN NOV17";
label variable HPEDE17 "HOLDER OF EMPL UNION INS IN DEC17";
label variable HPDJA17 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN17";
label variable HPDFE17 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB17";
label variable HPDMA17 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR17";
label variable HPDAP17 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR17";
label variable HPDMY17 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY17";
label variable HPDJU17 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN17";
label variable HPDJL17 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL17";
label variable HPDAU17 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG17";
label variable HPDSE17 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP17";
label variable HPDOC17 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT17";
label variable HPDNO17 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV17";
label variable HPDDE17 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC17";
label variable HPNJA17 "HOLDER OF NONGROUP INS IN JAN17";
label variable HPNFE17 "HOLDER OF NONGROUP INS IN FEB17";
label variable HPNMA17 "HOLDER OF NONGROUP INS IN MAR17";
label variable HPNAP17 "HOLDER OF NONGROUP INS IN APR17";
label variable HPNMY17 "HOLDER OF NONGROUP INS IN MAY17";
label variable HPNJU17 "HOLDER OF NONGROUP INS IN JUN17";
label variable HPNJL17 "HOLDER OF NONGROUP INS IN JUL17";
label variable HPNAU17 "HOLDER OF NONGROUP INS IN AUG17";
label variable HPNSE17 "HOLDER OF NONGROUP INS IN SEP17";
label variable HPNOC17 "HOLDER OF NONGROUP INS IN OCT17";
label variable HPNNO17 "HOLDER OF NONGROUP INS IN NOV17";
label variable HPNDE17 "HOLDER OF NONGROUP INS IN DEC17";
label variable HPOJA17 "HOLDER OF OTHER GROUP INS IN JAN17";
label variable HPOFE17 "HOLDER OF OTHER GROUP INS IN FEB17";
label variable HPOMA17 "HOLDER OF OTHER GROUP INS IN MAR17";
label variable HPOAP17 "HOLDER OF OTHER GROUP INS IN APR17";
label variable HPOMY17 "HOLDER OF OTHER GROUP INS IN MAY17";
label variable HPOJU17 "HOLDER OF OTHER GROUP INS IN JUN17";
label variable HPOJL17 "HOLDER OF OTHER GROUP INS IN JUL17";
label variable HPOAU17 "HOLDER OF OTHER GROUP INS IN AUG17";
label variable HPOSE17 "HOLDER OF OTHER GROUP INS IN SEP17";
label variable HPOOC17 "HOLDER OF OTHER GROUP INS IN OCT17";
label variable HPONO17 "HOLDER OF OTHER GROUP INS IN NOV17";
label variable HPODE17 "HOLDER OF OTHER GROUP INS IN DEC17";
label variable HPSJA17 "HOLDER OF SELF-EMP-1 INS IN JAN17";
label variable HPSFE17 "HOLDER OF SELF-EMP-1 INS IN FEB17";
label variable HPSMA17 "HOLDER OF SELF-EMP-1 INS IN MAR17";
label variable HPSAP17 "HOLDER OF SELF-EMP-1 INS IN APR17";
label variable HPSMY17 "HOLDER OF SELF-EMP-1 INS IN MAY17";
label variable HPSJU17 "HOLDER OF SELF-EMP-1 INS IN JUN17";
label variable HPSJL17 "HOLDER OF SELF-EMP-1 INS IN JUL17";
label variable HPSAU17 "HOLDER OF SELF-EMP-1 INS IN AUG17";
label variable HPSSE17 "HOLDER OF SELF-EMP-1 INS IN SEP17";
label variable HPSOC17 "HOLDER OF SELF-EMP-1 INS IN OCT17";
label variable HPSNO17 "HOLDER OF SELF-EMP-1 INS IN NOV17";
label variable HPSDE17 "HOLDER OF SELF-EMP-1 INS IN DEC17";
label variable HPXJA17 "HOLDER OF PRIV INS THROUGH EXCH IN JAN17";
label variable HPXFE17 "HOLDER OF PRIV INS THROUGH EXCH IN FEB17";
label variable HPXMA17 "HOLDER OF PRIV INS THROUGH EXCH IN MAR17";
label variable HPXAP17 "HOLDER OF PRIV INS THROUGH EXCH IN APR17";
label variable HPXMY17 "HOLDER OF PRIV INS THROUGH EXCH IN MAY17";
label variable HPXJU17 "HOLDER OF PRIV INS THROUGH EXCH IN JUN17";
label variable HPXJL17 "HOLDER OF PRIV INS THROUGH EXCH IN JUL17";
label variable HPXAU17 "HOLDER OF PRIV INS THROUGH EXCH IN AUG17";
label variable HPXSE17 "HOLDER OF PRIV INS THROUGH EXCH IN SEP17";
label variable HPXOC17 "HOLDER OF PRIV INS THROUGH EXCH IN OCT17";
label variable HPXNO17 "HOLDER OF PRIV INS THROUGH EXCH IN NOV17";
label variable HPXDE17 "HOLDER OF PRIV INS THROUGH EXCH IN DEC17";
label variable HPRJA17 "HOLDER OF PRIVATE INSURANCE IN JAN17";
label variable HPRFE17 "HOLDER OF PRIVATE INSURANCE IN FEB17";
label variable HPRMA17 "HOLDER OF PRIVATE INSURANCE IN MAR17";
label variable HPRAP17 "HOLDER OF PRIVATE INSURANCE IN APR17";
label variable HPRMY17 "HOLDER OF PRIVATE INSURANCE IN MAY17";
label variable HPRJU17 "HOLDER OF PRIVATE INSURANCE IN JUN17";
label variable HPRJL17 "HOLDER OF PRIVATE INSURANCE IN JUL17";
label variable HPRAU17 "HOLDER OF PRIVATE INSURANCE IN AUG17";
label variable HPRSE17 "HOLDER OF PRIVATE INSURANCE IN SEP17";
label variable HPROC17 "HOLDER OF PRIVATE INSURANCE IN OCT17";
label variable HPRNO17 "HOLDER OF PRIVATE INSURANCE IN NOV17";
label variable HPRDE17 "HOLDER OF PRIVATE INSURANCE IN DEC17";
label variable INSJA17X "COVR BY HOSP/MED INS IN JAN17 (ED)";
label variable INSFE17X "COVR BY HOSP/MED INS IN FEB17 (ED)";
label variable INSMA17X "COVR BY HOSP/MED INS IN MAR17 (ED)";
label variable INSAP17X "COVR BY HOSP/MED INS IN APR17 (ED)";
label variable INSMY17X "COVR BY HOSP/MED INS IN MAY17 (ED)";
label variable INSJU17X "COVR BY HOSP/MED INS IN JUN17 (ED)";
label variable INSJL17X "COVR BY HOSP/MED INS IN JUL17 (ED)";
label variable INSAU17X "COVR BY HOSP/MED INS IN AUG17 (ED)";
label variable INSSE17X "COVR BY HOSP/MED INS IN SEP17 (ED)";
label variable INSOC17X "COVR BY HOSP/MED INS IN OCT17 (ED)";
label variable INSNO17X "COVR BY HOSP/MED INS IN NOV17 (ED)";
label variable INSDE17X "COVR BY HOSP/MED INS IN DEC17 (ED)";
label variable PRVEV17 "EVER HAVE PRIVATE INSURANCE DURING 2017";
label variable TRIEV17 "EVER HAVE TRICARE/CHAMPVA DURING 2017";
label variable MCREV17 "EVER HAVE MEDICARE DURING 2017 (ED)";
label variable MCDEV17 "EVER HAVE MCAID/SCHIP DURING 2017 (ED)";
label variable OPAEV17 "EVER HAVE OTHER PUBLIC A INS DURING 2017";
label variable OPBEV17 "EVER HAVE OTHER PUBLIC B INS DURING 2017";
label variable UNINS17 "UNINSURED ALL OF 2017";
label variable INSCOV17 "HEALTH INSURANCE COVERAGE INDICATOR 2017";
label variable INSURC17 "FULL YEAR INSURANCE COVERAGE STATUS 2017";
label variable TRIST31X "COV BY TRICARE STANDARD-ANY TIME IN R3/1";
label variable TRIST42X "COV BY TRICARE STANDARD-ANY TIME IN R4/2";
label variable TRIST17X "CV BY TRICARE STANDARD-R5/3 TIL 12/31/17";
label variable TRIPR31X "COV BY TRICARE PRIME - ANY TIME IN R3/1";
label variable TRIPR42X "COV BY TRICARE PRIME - ANY TIME IN R4/2";
label variable TRIPR17X "COV BY TRICARE PRIME-R5/3 UNTIL 12/31/17";
label variable TRIEX31X "COV BY TRICARE EXTRA - ANY TIME IN R3/1";
label variable TRIEX42X "COV BY TRICARE EXTRA - ANY TIME IN R4/2";
label variable TRIEX17X "COV BY TRICARE EXTRA - R5/3 TIL 12/31/17";
label variable TRILI31X "COV BY TRICARE FOR LIFE-ANY TIME IN R3/1";
label variable TRILI42X "COV BY TRICARE FOR LIFE-ANY TIME IN R4/2";
label variable TRILI17X "CV BY TRICARE FOR LIFE-R5/3 TIL 12/31/17";
label variable TRICH31X "COVERED BY CHAMPVA - ANY TIME IN R3/1";
label variable TRICH42X "COVERED BY CHAMPVA - ANY TIME IN R4/2";
label variable TRICH17X "COVERED BY CHAMPVA - R5/3 UNTIL 12/31/17";
label variable MCRPD31 "COV BY MEDICARE PMED BENEFIT - R3/1";
label variable MCRPD42 "COV BY MEDICARE PMED BENEFIT - R4/2";
label variable MCRPD17 "COV BY MEDICARE PMED BENEFIT - 12/31/17";
label variable MCRPD31X "COV BY MEDICARE PMED BENEFIT - R3/1 (ED)";
label variable MCRPD42X "COV BY MEDICARE PMED BENEFIT - R4/2 (ED)";
label variable MCRPD17X "COV BY MCARE PMED BENEFIT-12/31/17 (ED)";
label variable MCRPB31 "COV BY MEDICARE PART B - R3/1";
label variable MCRPB42 "COV BY MEDICARE PART B - R4/2";
label variable MCRPB17 "COV BY MEDICARE PART B - 12/31/17";
label variable MCRPHO31 "COV BY MEDICARE MANAGED CARE - R3/1";
label variable MCRPHO42 "COV BY MEDICARE MANAGED CARE - R4/2";
label variable MCRPHO17 "COV BY MEDICARE MANAGED CARE - 12/31/17";
label variable MCDHMO31 "COV BY MCAID/SCHIP HMO -ANY TIME IN R3/1";
label variable MCDHMO42 "COV BY MCAID/SCHIP HMO -ANY TIME IN R4/2";
label variable MCDHMO17 "COV BY MCAID/SCHIP HMO-R5/3 TIL 12/31/17";
label variable MCDMC31 "CV MCAID/CHIP GTKPR PLN-ANY TIME IN R3/1";
label variable MCDMC42 "CV MCAID/CHIP GTKPR PLN-ANY TIME IN R4/2";
label variable MCDMC17 "CV MCD/CHIP GTKPR PLN-R5/3 TIL 12/31/17";
label variable PRVHMO31 "COVERED BY PRIVATE HMO-ANY TIME IN R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO-ANY TIME IN R4/2";
label variable PRVHMO17 "COVERED BY PRIVATE HMO-R5/3 TIL 12/31/17";
label variable FSAGT31 "ANYONE IN RU HAVE FSA - R3/1";
label variable HASFSA31 "PERSON IS FSA HOLDER - R3/1";
label variable FSAAMT31 "FSA TOTAL AMOUNT FOR RU - R3/1";
label variable PROBPY42 "FAMILY HAVING PROB PAYING MEDICAL BILLS";
label variable CRFMPY42 "FAMILY MED BILLS BEING PAID OVER TIME";
label variable PYUNBL42 "UNABLE TO PAY FAMILY MEDICAL BILLS";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PNL 22 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PNL 22 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 22 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PN 22 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 22 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PNL 22 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PNL 22 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PNL 22 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PN 22 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PNL 22 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PNL 22 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PNL 22 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PNL 22 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PNL 22 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PNL 22 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PNL 22 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 22 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 22 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-P22 ONLY";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 22 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PN 22 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 22 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 22 ONLY";
label variable TRICR31X "COV BY TRICR/CHAMV - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICR/CHAMV - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICR/CHAMV 12-31/R3 INT DT (ED)";
label variable TRICR17X "COV BY TRICR/CHAMV - 12/31/17 (ED)";
label variable TRIAT31X "COV TRICARE/CHAMPVA - ANY TIME IN R3/1";
label variable TRIAT42X "COV TRICARE/CHAMPVA - ANY TIME IN R4/2";
label variable TRIAT53X "COV TRICARE/CHAMPVA - ANY TIME IN R5/3";
label variable TRIAT17X "COV TRICARE/CHAMPVA-R5/3 UNTIL 12/31/17";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID17 "COV BY MEDICAID OR SCHIP - 12/31/17";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID17X "COV BY MEDICAID OR SCHIP - 12/31/17 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE17 "COV BY MEDICARE - 12/31/17";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE17X "COV BY MEDICARE - 12/31/17 (ED)";
label variable MCDAT31X "COV MEDICAID OR SCHIP - ANY TIME IN R3/1";
label variable MCDAT42X "COV MEDICAID OR SCHIP - ANY TIME IN R4/2";
label variable MCDAT53X "COV MEDICAID OR SCHIP - ANY TIME IN R5/3";
label variable MCDAT17X "CV MCD/CHIP-ANY TME IN R5/3 TIL 12/31/17";
label variable OTPAAT31 "COV OT GOV MCD/CHIP HMO-ANY TIME IN R3/1";
label variable OTPAAT42 "COV OT GOV MCD/CHIP HMO-ANY TIME IN R4/2";
label variable OTPAAT53 "COV OT GOV MCD/CHIP HMO-ANY TIME IN R5/3";
label variable OTPAAT17 "CV OT GOV MCD/CHIP HMO-R5/3 TIL 12/31/17";
label variable OTPBAT31 "CV OTGV NT MCD/CHIP HMO-ANY TIME IN R3/1";
label variable OTPBAT42 "CV OTGV NT MCD/CHIP HMO-ANY TIME IN R4/2";
label variable OTPBAT53 "CV OTGV NT MCD/CHIP HMO-ANY TIME IN R5/3";
label variable OTPBAT17 "CV OTGV NT MCD/CHP HMO-R5/3 TIL 12/31/17";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA17 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/17";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB17 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/17";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK17 "COV BY PRIV INS (DK PLAN) - 12/31/17";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU17 "COV BY EMPL/UNION GRP INS - 12/31/17";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING17 "COV BY NON-GROUP INS - 12/31/17";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG17 "COV BY OTHER GROUP INS - 12/31/17";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS17 "COV BY SELF-EMP-1 INS - 12/31/17";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT17 "COV BY SOMEONE OUT OF RU - 12/31/17";
label variable PRSTX31 "COV BY PRIV EXCHANGE INS -R3/1 INT DT";
label variable PRSTX42 "COV BY PRIV EXCHANGE INS -R4/2 INT DT";
label variable PRSTX53 "PRIV EXCHANGE INS ON 12-31 R5/R3 INT DT";
label variable PRSTX17 "PRIV EXCHANGE INSURANCE ON 12/31/17";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV17 "COV BY PRIV HLTH INS - 12/31/17";
label variable PRIVAT31 "COV BY PRIVATE INS - ANY TIME IN R3/1";
label variable PRIVAT42 "COV BY PRIVATE INS - ANY TIME IN R4/2";
label variable PRIVAT53 "COV BY PRIVATE INS - ANY TIME IN R5/3";
label variable PRIVAT17 "COV BY PRIVATE INS - R5/3 UNTIL 12/31/17";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB17X "COV BY PUBLIC INS - 12/31/17 (ED)";
label variable PUBAT31X "COV BY PUBLIC - ANY TIME IN R3/1";
label variable PUBAT42X "COV BY PUBLIC - ANY TIME IN R4/2";
label variable PUBAT53X "COV BY PUBLIC - ANY TIME IN R5/3";
label variable PUBAT17X "COV BY PUBLIC - R5/3 UNTIL 12/31/17";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS17X "INSURED - 12/31/17 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT17X "INSURED ANY TIME IN R5/R3 UNTIL 12/31/17";
label variable DENTIN31 "DENTAL INSURANCE - ANY TIME IN RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - ANY TIME IN RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - ANY TIME IN RD 5/3";
label variable DNTINS31 "DENTAL INS - ANY TIME IN RD 3/1 IN 2017";
label variable DNTINS17 "DENTL INS-ANY TIME IN R5/R3 TIL 12/31/17";
label variable PMEDIN31 "PMED INS - ANY TIME IN RD 3/1";
label variable PMEDIN42 "PMEDINS - ANY TIME IN RD 4/2";
label variable PMEDIN53 "PMEDINS - ANY TIME IN RD 5/3";
label variable PMDINS31 "PMED INS - RD 3/1 IN 2017";
label variable PMDINS17 "PMED INS - R5/R3 UNTIL 12/31/17";
label variable PMEDUP31 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R3/1";
label variable PMEDUP42 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R4/2";
label variable PMEDUP53 "HAS USUAL 3RD PARTY PAYER FOR PMEDS-R5/3";
label variable PMEDPY31 "USUAL 3RD PARTY PAYER FOR PMEDS - R3/1";
label variable PMEDPY42 "USUAL 3RD PARTY PAYER FOR PMEDS - R4/2";
label variable PMEDPY53 "USUAL 3RD PARTY PAYER FOR PMEDS - R5/3";
label variable TOTTCH17 "TOTAL HEALTH CARE CHARGES 17, EXCL RX";
label variable TOTEXP17 "TOTAL HEALTH CARE EXP 17";
label variable TOTSLF17 "TOTAL AMT PAID BY SELF/FAMILY 17";
label variable TOTMCR17 "TOTAL AMT PAID BY MEDICARE 17";
label variable TOTMCD17 "TOTAL AMT PAID BY MEDICAID 17";
label variable TOTPRV17 "TOTAL AMT PAID BY PRIVATE INS 17";
label variable TOTVA17 "TOTAL AMT PAID BY VA/CHAMPVA 17";
label variable TOTTRI17 "TOTAL AMT PAID BY TRICARE 17";
label variable TOTOFD17 "TOTAL AMT PAID BY OTHER FEDERAL 17";
label variable TOTSTL17 "TOTAL AMT PAID BY OTH ST/LOCAL 17";
label variable TOTWCP17 "TOTAL AMT PAID BY WORKERS COMP 17";
label variable TOTOPR17 "TOTAL AMT PAID BY OTHER PRIVATE 17";
label variable TOTOPU17 "TOTAL AMT PAID BY OTHER PUBLIC 17";
label variable TOTOSR17 "TOTAL AMT PAID BY OTHER SOURCES 17";
label variable TOTPTR17 "TOTAL AMT PAID BY PRV & TRI 17";
label variable TOTOTH17 "TOTAL AMT PAID BY OTH COMBINED 17";
label variable OBTOTV17 "# OFFICE-BASED PROVIDER VISITS 17";
label variable OBVTCH17 "OFFICE-BASED PROVIDER VISIT CHARGES 17";
label variable OBVEXP17 "TOTAL OFFICE-BASED EXP 17";
label variable OBVSLF17 "ALL OFFICE VISITS - SELF/FAMILY AMT 17";
label variable OBVMCR17 "ALL OFFICE VISITS - MEDICARE AMT 17";
label variable OBVMCD17 "ALL OFFICE VISITS - MEDICAID AMT 17";
label variable OBVPRV17 "ALL OFFICE VISITS - PRIVATE INS AMT 17";
label variable OBVVA17 "ALL OFFICE VISITS-VA/CHAMPVA AMT 17";
label variable OBVTRI17 "ALL OFFICE VISITS-TRICARE AMT 17";
label variable OBVOFD17 "ALL OFFICE VISITS-OTHER FEDERAL AMT 17";
label variable OBVSTL17 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 17";
label variable OBVWCP17 "ALL OFFICE VISITS - WORKERS COMP AMT 17";
label variable OBVOPR17 "ALL OFFICE VISITS - OTH PRIVATE AMT 17";
label variable OBVOPU17 "ALL OFFICE VISITS - OTH PUBLIC AMT 17";
label variable OBVOSR17 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 17";
label variable OBVPTR17 "ALL OFFICE VISITS - PRV & TRI AMT 17";
label variable OBVOTH17 "ALL OFFICE VISITS - OTH COMBINED AMT 17";
label variable OBDRV17 "# OFFICE-BASED PHYSICIAN VISITS 17";
label variable OBDTCH17 "OFFICE-BASED PHYSICIAN VISIT CHARGES 17";
label variable OBDEXP17 "TOTAL OFF-BASED DR EXP 17";
label variable OBDSLF17 "DR OFFICE VISITS - SELF/FAMILY AMT 17";
label variable OBDMCR17 "DR OFFICE VISITS - MEDICARE AMT 17";
label variable OBDMCD17 "DR OFFICE VISITS - MEDICAID AMT 17";
label variable OBDPRV17 "DR OFFICE VISITS - PRIVATE INS AMT 17";
label variable OBDVA17 "DR OFFICE VISITS - VA/CHAMPVA AMT 17";
label variable OBDTRI17 "DR OFFICE VISITS - TRICARE AMT 17";
label variable OBDOFD17 "DR OFFICE VISITS - OTHER FEDERAL AMT 17";
label variable OBDSTL17 "DR OFFICE VISITS - OTH ST/LOCAL AMT 17";
label variable OBDWCP17 "DR OFFICE VISITS - WORKERS COMP AMT 17";
label variable OBDOPR17 "DR OFFICE VISITS - OTH PRIVATE AMT 17";
label variable OBDOPU17 "DR OFFICE VISITS - OTH PUBLIC AMT 17";
label variable OBDOSR17 "DR OFF VSTS - OTH UNCLASS SRCE AMT 17";
label variable OBDPTR17 "DR OFFICE VISITS - PRV & TRI AMT 17";
label variable OBDOTH17 "DR OFFICE VISITS - OTH COMBINED AMT 17";
label variable OPTOTV17 "# OUTPATIENT DEPT PROVIDER VISITS 17";
label variable OPTTCH17 "OPD FACILITY + DR VISIT CHARGES - 17";
label variable OPTEXP17 "TOTAL OUTPATIENT FAC + DR EXP 17";
label variable OPTSLF17 "ALL OPD VSTS-SELF/FAMILY AMT-(FAC+DR) 17";
label variable OPTMCR17 "ALL OPD VSTS-MEDICARE AMT-(FAC+DR) 17";
label variable OPTMCD17 "ALL OPD VSTS-MEDICAID AMT-(FAC+DR) 17";
label variable OPTPRV17 "ALL OPD VSTS-PRIV INS AMT-(FAC+DR) 17";
label variable OPTVA17 "ALL OPD VSTS-VA/CHAMPVA AMT-(FAC+DR) 17";
label variable OPTTRI17 "ALL OPD VSTS-TRICARE AMT-(FAC+DR) 17";
label variable OPTOFD17 "ALL OPD VSTS-OTHER FED AMT-(FAC+DR) 17";
label variable OPTSTL17 "ALL OPD VST-OTH ST/LOCAL AMT(FAC+DR) 17";
label variable OPTWCP17 "ALL OPD VST-WORKRS COMP AMT-(FAC+DR) 17";
label variable OPTOPR17 "ALL OPD VSTS-OTH PRIVATE AMT-(FAC+DR) 17";
label variable OPTOPU17 "ALL OPD VSTS-OTH PUBLIC AMT-(FAC+DR) 17";
label variable OPTOSR17 "ALL OPD VST-OTH UNCLS SRC AMT(FAC+DR) 17";
label variable OPTPTR17 "ALL OPD VISITS-PRV & TRI AMT (FAC+DR) 17";
label variable OPTOTH17 "ALL OPD VSTS-OTH COMBINED AMT(FAC+DR) 17";
label variable OPFTCH17 "OPD PROVIDER VISIT CHARGES - FAC 17";
label variable OPFEXP17 "TOTAL OUTPATIENT FACILITY EXP 17";
label variable OPFSLF17 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 17";
label variable OPFMCR17 "ALL OPD VISITS-MEDICARE AMT-FAC 17";
label variable OPFMCD17 "ALL OPD VISITS-MEDICAID AMT-FAC 17";
label variable OPFPRV17 "ALL OPD VISITS-PRIV INS AMT-FAC 17";
label variable OPFVA17 "ALL OPD VISITS-VA/CHAMPVA AMT-FAC 17";
label variable OPFTRI17 "ALL OPD VISITS-TRICARE AMT-FAC 17";
label variable OPFOFD17 "ALL OPD VISITS-OTHER FED AMT-FAC 17";
label variable OPFSTL17 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 17";
label variable OPFWCP17 "ALL OPD VISITS-WORKERS COMP AMT-FAC 17";
label variable OPFOPR17 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 17";
label variable OPFOPU17 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 17";
label variable OPFOSR17 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 17";
label variable OPFPTR17 "ALL OPD VISITS - PRV & TRI AMT-FAC 17";
label variable OPFOTH17 "ALL OPD VISITS - OTH COMBINED AMT-FAC 17";
label variable OPDEXP17 "TOTAL OUTPATIENT PROVIDER EXP 17";
label variable OPDTCH17 "OPD PROVIDER VISIT CHARGES - DR 17";
label variable OPDSLF17 "ALL OPD VISITS-SELF/FAMILY AMT-DR 17";
label variable OPDMCR17 "ALL OPD VISITS-MEDICARE AMT-DR 17";
label variable OPDMCD17 "ALL OPD VISITS-MEDICAID AMT-DR 17";
label variable OPDPRV17 "ALL OPD VISITS-PRIV INS AMT-DR 17";
label variable OPDVA17 "ALL OPD VISITS-VA/CHAMPVA AMT-DR 17";
label variable OPDTRI17 "ALL OPD VISITS-TRICARE AMT-DR 17";
label variable OPDOFD17 "ALL OPD VISITS-OTHER FED AMT-DR 17";
label variable OPDSTL17 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 17";
label variable OPDWCP17 "ALL OPD VISITS-WORKERS COMP AMT-DR 17";
label variable OPDOPR17 "ALL OPD VISITS - OTH PRIVATE AMT-DR 17";
label variable OPDOPU17 "ALL OPD VISITS-OTH PUBLIC AMT-DR 17";
label variable OPDOSR17 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 17";
label variable OPDPTR17 "ALL OPD VISITS-PRV & TRI AMT -DR 17";
label variable OPDOTH17 "ALL OPD VISITS-OTH COMBINED AMT-DR 17";
label variable OPDRV17 "# OUTPATIENT DEPT PHYSICIAN VISITS 17";
label variable OPVTCH17 "OPD PHYSICIAN VISIT CHARGES - FAC 17";
label variable OPVEXP17 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 17";
label variable OPVSLF17 "OPD DR VISITS-SELF/FAMILY AMT-FAC 17";
label variable OPVMCR17 "OPD DR VISITS-MEDICARE AMT-FAC 17";
label variable OPVMCD17 "OPD DR VISITS-MEDICAID AMT-FAC 17";
label variable OPVPRV17 "OPD DR VISITS-PRIV INS AMT-FAC 17";
label variable OPVVA17 "OPD DR VISITS-VA/CHAMPVA AMT-FAC 17";
label variable OPVTRI17 "OPD DR VISITS-TRICARE AMT-FAC 17";
label variable OPVOFD17 "OPD DR VISITS-OTHER FED AMT-FAC 17";
label variable OPVSTL17 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 17";
label variable OPVWCP17 "OPD DR VISITS-WORKERS COMP AMT-FAC 17";
label variable OPVOPR17 "OPD DR VISITS - OTH PRIVATE AMT-FAC 17";
label variable OPVOPU17 "OPD DR VISITS-OTH PUBLIC AMT-FAC 17";
label variable OPVOSR17 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 17";
label variable OPVPTR17 "OPD DR VISITS - PRV & TRI AMT-FAC 17";
label variable OPVOTH17 "OPD DR VISITS - OTH COMBINED AMT-FAC 17";
label variable OPSEXP17 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 17";
label variable OPSTCH17 "OPD PHYSICIAN VISIT CHARGES - DR 17";
label variable OPSSLF17 "OPD DR VISITS-SELF/FAMILY AMT-DR 17";
label variable OPSMCR17 "OPD DR VISITS-MEDICARE AMT-DR 17";
label variable OPSMCD17 "OPD DR VISITS-MEDICAID AMT-DR 17";
label variable OPSPRV17 "OPD DR VISITS-PRIV INS AMT-DR 17";
label variable OPSVA17 "OPD DR VISITS-VA/CHAMPVA AMT-DR 17";
label variable OPSTRI17 "OPD DR VISITS-TRICARE AMT-DR 17";
label variable OPSOFD17 "OPD DR VISITS-OTHER FED AMT-DR 17";
label variable OPSSTL17 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 17";
label variable OPSWCP17 "OPD DR VISITS-WORKERS COMP AMT-DR 17";
label variable OPSOPR17 "OPD DR VISITS - OTH PRIVATE AMT-DR 17";
label variable OPSOPU17 "OPD DR VISITS-OTH PUBLIC AMT-DR 17";
label variable OPSOSR17 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 17";
label variable OPSPTR17 "OPD DR VISITS - PRV & TRI AMT-DR 17";
label variable OPSOTH17 "OPD DR VISITS -OTH COMBINED AMT-DR 17";
label variable ERTOT17 "# EMERGENCY ROOM VISITS 17";
label variable ERTTCH17 "ER FACILITY + DR VISIT CHARGES 17";
label variable ERTEXP17 "TOTAL ER FACILITY + DR EXP 17";
label variable ERTSLF17 "ER-SELF/FAMILY AMT-(FAC+DR) 17";
label variable ERTMCR17 "ER-MEDICARE AMT-(FAC+DR) 17";
label variable ERTMCD17 "ER-MEDICAID AMT-(FAC+DR) 17";
label variable ERTPRV17 "ER-PRIV INS AMT-(FAC+DR) 17";
label variable ERTVA17 "ER-VA/CHAMPVA AMT-(FAC+DR) 17";
label variable ERTTRI17 "ER-TRICARE AMT-(FAC+DR) 17";
label variable ERTOFD17 "ER-OTHER FED AMT-(FAC+DR) 17";
label variable ERTSTL17 "ER-OTH ST/LOCAL AMT-(FAC+DR) 17";
label variable ERTWCP17 "ER-WORKERS COMP AMT-(FAC+DR) 17";
label variable ERTOPR17 "ER-OTH PRIVATE AMT-(FAC+DR) 17";
label variable ERTOPU17 "ER-OTH PUBLIC AMT-(FAC+DR) 17";
label variable ERTOSR17 "ER-OTH UNCLASS SRCE AMT-(FAC+DR) 17";
label variable ERTPTR17 "ER-PRV & TRI AMT (FAC+DR) 17";
label variable ERTOTH17 "ER -OTH COMBINED AMT (FAC+DR) 17";
label variable ERFTCH17 "ER FACILITY VISIT CHARGES 17";
label variable ERFEXP17 "TOTAL ER FACILITY EXP 17";
label variable ERFSLF17 "ER-SELF/FAMILY AMT - FAC 17";
label variable ERFMCR17 "ER-MEDICARE AMT - FAC 17";
label variable ERFMCD17 "ER-MEDICAID AMT - FAC 17";
label variable ERFPRV17 "ER-PRIVATE INS AMT - FAC 17";
label variable ERFVA17 "ER-VA/CHAMPVA AMT - FAC 17";
label variable ERFTRI17 "ER-TRICARE AMT - FAC 17";
label variable ERFOFD17 "ER-OTHER FEDERAL AMT - FAC 17";
label variable ERFSTL17 "ER-OTH ST/LOCAL AMT - FAC 17";
label variable ERFWCP17 "ER-WORKERS COMP AMT - FAC 17";
label variable ERFOPR17 "ER-OTHER PRIVATE AMT - FAC 17";
label variable ERFOPU17 "ER-OTHER PUBLIC AMT - FAC 17";
label variable ERFOSR17 "ER-OTH UNCLASS SRCE AMT - FAC 17";
label variable ERFPTR17 "ER-PRV & TRI AMT - FAC 17";
label variable ERFOTH17 "ER-OTH COMBINED AMT - FAC 17";
label variable ERDEXP17 "TOTAL EMERGENCY ROOM DR EXP 17";
label variable ERDTCH17 "ER DOCTOR VISIT CHARGES 17";
label variable ERDSLF17 "ER-SELF/FAMILY AMT - DR 17";
label variable ERDMCR17 "ER-MEDICARE AMT - DR 17";
label variable ERDMCD17 "ER-MEDICAID AMT - DR 17";
label variable ERDPRV17 "ER-PRIVATE INS AMT - DR 17";
label variable ERDVA17 "ER-VA/CHAMPVA AMT - DR 17";
label variable ERDTRI17 "ER-TRICARE AMT - DR 17";
label variable ERDOFD17 "ER-OTHER FED AMT - DR 17";
label variable ERDSTL17 "ER-OTH ST/LOCAL AMT - DR 17";
label variable ERDWCP17 "ER-WORKERS COMP AMT - DR 17";
label variable ERDOPR17 "ER - OTHER PRIVATE AMT - DR 17";
label variable ERDOPU17 "ER - OTHER PUBLIC AMT - DR 17";
label variable ERDOSR17 "ER-OTH UNCLASS SRCE AMT - DR 17";
label variable ERDPTR17 "ER-PRV & TRI AMT - DR 17";
label variable ERDOTH17 "ER-OTH COMBINED AMT - DR 17";
label variable IPDIS17 "# HOSPITAL DISCHARGES, 2017";
label variable IPTEXP17 "TOT HOSP IP FACILITY + DR EXP 17";
label variable IPTTCH17 "IP HOSP STAY CHARGES (FAC+DR) 17";
label variable IPTSLF17 "IP HOSP STAZ-SELF/FAMILY AMT-(FAC+DR) 17";
label variable IPTMCR17 "IP HOSP STAZ-MEDICARE AMT-(FAC+DR) 17";
label variable IPTMCD17 "IP HOSP STAZ-MEDICAID AMT-(FAC+DR) 17";
label variable IPTPRV17 "IP HOSP STAZ-PRIV INS AMT-(FAC+DR) 17";
label variable IPTVA17 "IP HOSP STAZ-VA/CHAMPVA AMT-(FAC+DR) 17";
label variable IPTTRI17 "IP HOSP STAZ-TRICARE AMT-(FAC+DR) 17";
label variable IPTOFD17 "IP HOSP STAZ-OTHER FED AMT-(FAC+DR) 17";
label variable IPTSTL17 "IP HSP STAZ-OTH ST/LOCAL AMT-(FAC+DR) 17";
label variable IPTWCP17 "IP HOSP STAZ-WRKRS COMP AMT-(FAC+DR) 17";
label variable IPTOPR17 "IP HOSP STAZ-OTH PRIVATE AMT-(FAC+DR) 17";
label variable IPTOPU17 "IP HOSP STAZ-OTH PUBLIC AMT-(FAC+DR) 17";
label variable IPTOSR17 "IP HSP STAZ-OTH UNCLS SRC AMT(FAC+DR) 17";
label variable IPTPTR17 "IP HOSP STAZ-PRV & TRI AMT-(FAC+DR) 17";
label variable IPTOTH17 "IP HOSP STAZ-OTH COMBINED AMT(FAC+DR) 17";
label variable IPFEXP17 "TOT HOSP IP FACILITY EXP-INC 0 NITES 17";
label variable IPFTCH17 "IP HOSP STAY CHARGES - FAC 17";
label variable IPFSLF17 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 17";
label variable IPFMCR17 "IP HOSP STAZ-MEDICARE AMT-FAC 17";
label variable IPFMCD17 "IP HOSP STAZ-MEDICAID AMT-FAC 17";
label variable IPFPRV17 "IP HOSP STAZ-PRIV INS AMT-FAC 17";
label variable IPFVA17 "IP HOSP STAZ-VA/CHAMPVA AMT-FAC 17";
label variable IPFTRI17 "IP HOSP STAZ-TRICARE AMT-FAC 17";
label variable IPFOFD17 "IP HOSP STAZ-OTHER FED AMT-FAC 17";
label variable IPFSTL17 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 17";
label variable IPFWCP17 "IP HOSP STAZ-WORKERS COMP AMT-FAC 17";
label variable IPFOPR17 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 17";
label variable IPFOPU17 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 17";
label variable IPFOSR17 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 17";
label variable IPFPTR17 "IP HOSP STAZ-PRV & TRI AMT-FAC 17";
label variable IPFOTH17 "IP HOSP STAZ-OTH COMBINED AMT-FAC 17";
label variable IPDEXP17 "TOTL HOSP STAZ DR EXP 17";
label variable IPDTCH17 "IP HOSP STAY CHARGES - DR 17";
label variable IPDSLF17 "IP HOSP STAZ-SELF/FAMILY AMT-DR 17";
label variable IPDMCR17 "IP HOSP STAZ-MEDICARE AMT- DR 17";
label variable IPDMCD17 "IP HOSP STAZ-MEDICAID AMT-DR 17";
label variable IPDPRV17 "IP HOSP STAZ-PRIV INS AMT-DR 17";
label variable IPDVA17 "IP HOSP STAZ-VA/CHAMPVA AMT-DR 17";
label variable IPDTRI17 "IP HOSP STAZ-TRICARE AMT-DR 17";
label variable IPDOFD17 "IP HOSP STAZ-OTHER FED AMT-DR 17";
label variable IPDSTL17 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 17";
label variable IPDWCP17 "IP HOSP STAZ-WORKERS COMP AMT-DR 17";
label variable IPDOPR17 "IP HOSP STAZ - OTH PRIVATE AMT-DR 17";
label variable IPDOPU17 "IP HOSP STAZ - OTH PUBLIC AMT-DR 17";
label variable IPDOSR17 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 17";
label variable IPDPTR17 "IP HOSP STAZ-PRV & TRI AMT-DR 17";
label variable IPDOTH17 "IP HOSP STAZ-OTH COMBINED AMT-DR 17";
label variable IPNGTD17 "# NIGHTS IN HOSP FOR DISCHARGES, 2017";
label variable DVTOT17 "# DENTAL CARE VISITS 17";
label variable DVTTCH17 "TOTAL DENTAL CARE VISIT CHARGES 17";
label variable DVTEXP17 "TOTAL DENTAL CARE EXP 17";
label variable DVTSLF17 "ALL DENTAL CARE - SELF/FAMILY AMT 17";
label variable DVTMCR17 "ALL DENTAL CARE - MEDICARE AMT 17";
label variable DVTMCD17 "ALL DENTAL CARE - MEDICAID AMT 17";
label variable DVTPRV17 "ALL DENTAL CARE - PRIVATE INS AMT 17";
label variable DVTVA17 "ALL DENTAL CARE - VA/CHAMPVA AMT 17";
label variable DVTTRI17 "ALL DENTAL CARE - TRICARE AMT 17";
label variable DVTOFD17 "ALL DENTAL CARE - OTHER FEDRL AMT 17";
label variable DVTSTL17 "ALL DENTAL CARE - OTH ST/LOCAL AMT 17";
label variable DVTWCP17 "ALL DENTAL CARE - WORKERS COMP AMT 17";
label variable DVTOPR17 "ALL DENTAL CARE - OTH PRIVATE AMT 17";
label variable DVTOPU17 "ALL DENTAL CARE - OTH PUBLIC AMT 17";
label variable DVTOSR17 "ALL DENT CARE-OT UNCLASS SRCE AMT 17";
label variable DVTPTR17 "ALL DENTAL CARE - PRV & TRI AMT 17";
label variable DVTOTH17 "ALL DENTAL CARE - OTH COMBINED AMT 17";
label variable HHTOTD17 "# HOME HEALTH PROVIDER DAYS, 2017";
label variable HHAGD17 "# AGENCY HOME HEALTH PROVIDER DAYS 17";
label variable HHATCH17 "HOME HEALTH AGENCY VISIT CHARGES 17";
label variable HHAEXP17 "TOTAL HOME HEALTH AGENCY EXP 17";
label variable HHASLF17 "HOME HLTH AGENCY - SELF/FAMILY AMT 17";
label variable HHAMCR17 "HOME HLTH AGENCY - MEDICARE AMT 17";
label variable HHAMCD17 "HOME HLTH AGENCY - MEDICAID AMT 17";
label variable HHAPRV17 "HOME HLTH AGENCY - PRIVATE INS AMT 17";
label variable HHAVA17 "HOME HLTH AGENCY-VA/CHAMPVA AMT 17";
label variable HHATRI17 "HOME HLTH AGENCY-TRICARE AMT 17";
label variable HHAOFD17 "HOME HLTH AGENCY - OTHER FED AMT 17";
label variable HHASTL17 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 17";
label variable HHAWCP17 "HOME HLTH AGENCY - WORKERS COMP AMT 17";
label variable HHAOPR17 "HOME HLTH AGENCY - OTH PRIVATE AMT 17";
label variable HHAOPU17 "HOME HLTH AGENCY - OTH PUBLIC AMT 17";
label variable HHAOSR17 "H HLTH AGENCY - OT UNCLASS SRCE AMT 17";
label variable HHAPTR17 "HOME HLTH AGENCY - PRV & TRI AMT 17";
label variable HHAOTH17 "HOME HLTH AGENCY - OTH COMBINED AMT 17";
label variable HHINDD17 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 17";
label variable HHNTCH17 "HOME HEALTH NON-AGENCY VISIT CHARGES 17";
label variable HHNEXP17 "TOTAL HOME HEALTH NON-AGNCY EXP 17";
label variable HHNSLF17 "HOME HLTH NON-AGNCY - SELF/FAM AMT 17";
label variable HHNMCD17 "HOME HLTH NON-AGNCY - MEDICAID AMT 17";
label variable HHNMCR17 "HOME HLTH NON-AGNCY - MEDICARE AMT 17";
label variable HHNPRV17 "HOME HLTH NON-AGNCY - PRIV INS AMT 17";
label variable HHNVA17 "HOME HLTH NON-AGNCY-VA/CHAMPVA AMT 17";
label variable HHNTRI17 "HOME HLTH NON-AGNCY-TRICARE AMT 17";
label variable HHNOFD17 "HOME HLTH NON-AGNCY-OTHR FED AMT 17";
label variable HHNSTL17 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 17";
label variable HHNWCP17 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 17";
label variable HHNOPR17 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 17";
label variable HHNOPU17 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 17";
label variable HHNOSR17 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 17";
label variable HHNPTR17 "HOME HLTH NON-AGNCY - PRV & TRI AMT 17";
label variable HHNOTH17 "HOME HLTH NON-AGNCY-OTH COMBINED AMT 17";
label variable HHINFD17 "# INFORMAL HOME HEALTH PROVIDER DAYS 17";
label variable VISEXP17 "TOTAL GLASSES/CONTACT LENS EXP 17";
label variable VISTCH17 "GLASSES/CONTACT LENSES CHARGES 17";
label variable VISSLF17 "GLASSES/CNTCT LENSES -SELF/FAM AMT 17";
label variable VISMCR17 "GLASSES/CNTCT LENSES-MEDICARE AMT 17";
label variable VISMCD17 "GLASSES/CNTCT LENSES-MEDICAID AMT 17";
label variable VISPRV17 "GLASSES/CNTCT LENSES-PRIV INS AMT 17";
label variable VISVA17 "GLASSES/CNTCT LENSES-VA/CHAMPVA AMT 17";
label variable VISTRI17 "GLASSES/LENSES-TRICARE AMT 17";
label variable VISOFD17 "GLASSES/CNTCT LENSES-OTHR FED AMT 17";
label variable VISSTL17 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 17";
label variable VISWCP17 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 17";
label variable VISOPR17 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 17";
label variable VISOPU17 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 17";
label variable VISOSR17 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 17";
label variable VISPTR17 "GLASSES/CNTCT LENSES-PRV & TRI AMT 17";
label variable VISOTH17 "GLASSES/CNTCT LENSES-OTH COMBINED AMT 17";
label variable OTHTCH17 "OTHER EQUP/SUPPLIES CHARGES 17";
label variable OTHEXP17 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 17";
label variable OTHSLF17 "OTHER EQUP/SUPPLIES-SELF/FAM AMT 17";
label variable OTHMCR17 "OTHER EQUP/SUPPLIES-MEDICARE AMT 17";
label variable OTHMCD17 "OTHER EQUP/SUPPLIES-MEDICAID AMT 17";
label variable OTHPRV17 "OTHER EQUP/SUPPLIES-PRIV INS AMT 17";
label variable OTHVA17 "OTHER EQUP/SUPPLY-VA/CHAMPVA AMT 17";
label variable OTHTRI17 "OTHER EQUP/SUPPLY-TRICARE AMT 17";
label variable OTHOFD17 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 17";
label variable OTHSTL17 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 17";
label variable OTHWCP17 "OTHER EQUP/SUPPLY - WORKERS COMP AMT 17";
label variable OTHOPR17 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 17";
label variable OTHOPU17 "OTHER EQUP/SUPPLY - OTH PUBLIC AMT 17";
label variable OTHOSR17 "OTH EQUP/SUPLY - OT UNCLASS SRCE AMT 17";
label variable OTHPTR17 "OTHER EQUP/SUPPLY - PRV & TRI AMT 17";
label variable OTHOTH17 "OTHER EQUP/SUPPLY - OTH COMBINED AMT 17";
label variable RXTOT17 "# PRESC MEDS INCL REFILLS 17";
label variable RXEXP17 "TOTAL RX-EXP 17";
label variable RXSLF17 "TOTAL RX-SELF/FAMILY AMT 17";
label variable RXMCR17 "TOTAL RX-MEDICARE AMT 17";
label variable RXMCD17 "TOTAL RX-MEDICAID AMT 17";
label variable RXPRV17 "TOTAL RX-PRIVATE INS AMT 17";
label variable RXVA17 "TOTAL RX-VA/CHAMPVA AMT 17";
label variable RXTRI17 "TOTAL RX-TRICARE AMT 17";
label variable RXOFD17 "TOTAL RX-OTHER FED AMT 17";
label variable RXSTL17 "TOTAL RX-OTHER ST/LOCAL AMT 17";
label variable RXWCP17 "TOTAL RX-WORKERS COMP AMT 17";
label variable RXOPR17 "TOTAL RX-OTH PRIVATE AMT 17";
label variable RXOPU17 "TOTAL RX-OTH PUBLIC AMT 17";
label variable RXOSR17 "TOT RX-OTH UNCLASS SRCE AMT 17";
label variable RXPTR17 "TOTAL RX-PRV & TRI AMT 17";
label variable RXOTH17 "TOTAL RX-OTH COMBINED AMT 17";
label variable PERWT17F "FINAL PERSON WEIGHT, 2017";
label variable FAMWT17F "FINAL FAMILY WEIGHT, 2017";
label variable FAMWT17C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/17";
label variable SAQWT17F "FINAL SAQ PERSON WEIGHT, 2017";
label variable DIABW17F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable CSAQW17F "FINAL CANCER SAQ PERSON WEIGHT - 2017";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2017";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2017";


*DEFINE VALUE LABELS FOR REPORTS;
label define H2010001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H2010002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H2010003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H2010004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H2010005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2010007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H2010008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H2010009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H2010012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H2010013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2010014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2010015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 A GOOD BIT OF THE TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H2010016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2010021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H2010024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2010025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H2010028X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H2010029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT AT ALL"
         1 "1 SEVERAL DAYS"
         2 "2 MORE THAN HALF THE DAYS"
         3 "3 NEARLY EVERY DAY" ;

label define H2010031X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H2010032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2010035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2010036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H2010037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H2010038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H2010039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 A GOOD BIT OF THE TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H2010040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF ADMINISTERED"
         2 "2 HUSBAND OR WIFE"
         3 "3 UNMARRIED PARTNER"
         4 "4 MOTHER, FATHER OR GUARDIAN"
         5 "5 SON OR DAUGHTER"
         6 "6 OTHER RELATIVE"
         7 "7 NOT RELATED" ;

label define H2010041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 A GOOD BIT OF THE TIME"
         4 "4 SOME OF THE TIME"
         5 "5 LITTLE OF THE TIME"
         6 "6 NONE OF THE TIME" ;

label define H2010042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2010045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H2010046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2010049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H2010052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2010055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NONE OF THE TIME"
         2 "2 LITTLE OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 MOST OF THE TIME"
         5 "5 ALL OF THE TIME" ;

label define H2010056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE OF THE TIME"
         1 "1 LITTLE OF THE TIME"
         2 "2 SOME OF THE TIME"
         3 "3 MOST OF THE TIME"
         4 "4 ALL OF THE TIME" ;

label define H2010057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H2010058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010059X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2010060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010062X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 RHEUMATOID ARTHRITIS"
         2 "2 OSTEOARTHRITIS"
         3 "3 NOT SPECIFIED" ;

label define H2010066X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010067X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010069X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010070X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST 2 YEARS"
         2 "2 WITHIN PAST 3 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H2010072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2010073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2010074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2010075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2016 "2016 YEAR"
         2017 "2017 YEAR" ;

label define H2010076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2017 "2017 YEAR" ;

label define H2010077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2017 "2017 YEAR"
         2018 "2018 YEAR" ;

label define H2010078X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2010079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010082X
         -1 "-1 INAPPLICABLE, THOSE WHO ARE DEC/INSTD"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2010085X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2010086X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2010087X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2010088X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2010089X
         -1 "-1 INAPPLICABLE"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H2010090X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2010091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010098X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010101X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010104X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010105X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010106X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010107X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010108X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010109X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010110X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010111X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010112X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010113X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010114X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010115X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010116X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010117X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 RARELY"
         3 "3 SOMETIMES"
         4 "4 OFTEN"
         5 "5 ALL THE TIME" ;

label define H2010118X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010119X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NONE"
         2 "2 MILD"
         3 "3 MODERATE"
         4 "4 SEVERE"
         5 "5 VERY SEVERE" ;

label define H2010120X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010121X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 6 MONTHS"
         2 "2 6 MONTHS TO LESS THAN 1 YEAR"
         3 "3 1 YEAR TO LESS THAN 3 YEARS"
         4 "4 3 YEARS TO LESS THAN 5 YEARS"
         5 "5 5 YEARS TO LESS THAN 10 YEARS"
         6 "6 MORE THAN 10 YEARS" ;

label define H2010122X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2010123X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 RARELY"
         3 "3 SOMETIMES"
         4 "4 OFTEN"
         5 "5 ALWAYS" ;

label define H2010124X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010125X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010126X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COMPLETELY"
         2 "2 MOSTLY"
         3 "3 MODERATELY"
         4 "4 A LITTLE"
         5 "5 NOT AT ALL" ;

label define H2010127X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2010128X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         0 "0 0 - NO PAIN"
         1 "1 1"
         10 "10 10 - WORST IMAGINABLE PAIN"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5"
         6 "6 6"
         7 "7 7"
         8 "8 8"
         9 "9 9" ;

label define H2010129X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010130X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2010131X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2010132X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010133X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010134X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010135X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010136X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010137X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010138X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010139X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010140X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DON'T KNOW" ;

label define H2010141X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010142X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010143X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010144X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010145X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010146X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010147X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010148X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010149X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NO CAREGIVERS EMPLOYED WHILE PROV CARE"
         4 "4 DON'T KNOW" ;

label define H2010150X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN $10,000"
         2 "2 $10,000 TO $24,999"
         3 "3 $25,000 TO $49,999"
         4 "4 $50,000 TO $74,999"
         5 "5 $75,000 TO $99,999"
         6 "6 $100,000 OR MORE" ;

label define H2010151X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010152X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010153X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010154X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010155X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010156X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010157X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010158X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010159X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010160X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010161X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010162X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010163X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010164X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H2010166X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010174X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010175X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H2010176X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H2010177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H2010178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010182X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010183X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2010184X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010185X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010186X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010187X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010188X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010189X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010195X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010196X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010197X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010200X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010205X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DOES NOT APPLY" ;

label define H2010206X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT AT ALL DIFFICULT"
         4 "4 DON'T KNOW"
         5 "5 DOES NOT APPLY" ;

label define H2010207X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BETTER"
         2 "2 ABOUT THE SAME"
         3 "3 WORSE"
         4 "4 DON'T KNOW"
         5 "5 DOES NOT APPLY" ;

label define H2010208X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DON'T KNOW" ;

label define H2010209X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT AT ALL DIFFICULT"
         4 "4 DON'T KNOW"
         5 "5 DOES NOT APPLY" ;

label define H2010210X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010211X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010212X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010213X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010214X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010215X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010216X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DOES NOT APPLY" ;

label define H2010217X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010218X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010219X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010220X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010221X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010222X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010223X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010224X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR AGO"
         2 "2 1 YEAR AGO TO LESS THAN 3 YEARS AGO"
         3 "3 3 YEARS AGO TO LESS THAN 5 YEARS AGO"
         4 "4 5 YEARS AGO TO LESS THAN 10 YEARS AGO"
         5 "5 10 YEARS AGO TO 20 YEARS AGO"
         6 "6 MORE THAN 20 YEARS AGO"
         7 "7 NO, HAVE NOT BEEN TREATED FOR CANCER" ;

label define H2010225X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H2010226X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H2010227X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010228X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H2010229X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H2010230X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H2010231X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISCUSSED IN DETAIL"
         2 "2 BRIEFLY DISCUSSED"
         3 "3 DID NOT DISCUSS"
         4 "4 DON'T REMEMBER" ;

label define H2010232X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010233X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010234X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010235X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H2010236X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H2010237X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H2010238X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H2010239X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H2010240X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H2010241X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H2010242X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, A REASON"
         2 "2 NO, NOT A REASON" ;

label define H2010243X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010244X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010245X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010246X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010247X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010248X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010249X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010250X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010251X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010252X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010253X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H2010254X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010256X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010257X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT REQUIRED TO PERFORM PHYS TASK" ;

label define H2010258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010259X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H2010260X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2010261X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 DOES NOT APPLY" ;

label define H2010262X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010263X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010264X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010265X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DUE TO CANCER, TREATMENT, EFFECTS"
         2 "2 SOME OTHER REASON" ;

label define H2010266X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2010267X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010268X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2010270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010271X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010272X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010273X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010282X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H2010284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H2010285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES (WAGE AMOUNT CHANGED)"
         2 "2 NO (WAGE AMOUNT DID NOT CHANGE)" ;

label define H2010286X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H2010287X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H2010288X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H2010289X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2010290X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H2010293X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010294X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H2010297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2010298X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010299X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE"
         96 "96 DID NOT HAVE A1C BLOOD TEST" ;

label define H2010301X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010302X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010307X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT CONFIDENT AT ALL"
         2 "2 SOMEWHAT CONFIDENT"
         3 "3 CONFIDENT"
         4 "4 VERY CONFIDENT" ;

label define H2010310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010313X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010314X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010315X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010316X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010317X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010318X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010319X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010320X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010321X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010322X
         -1 "-1  INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8  DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010323X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010324X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010325X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010326X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010327X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010328X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010329X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010330X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010331X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010334X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010335X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010336X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H2010337X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2010338X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2010339X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2010340X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H2010341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H2010344X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 3/1" ;

label define H2010345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H2010346X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 4/2" ;

label define H2010347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H2010348X
         -1 "-1 INAPPLICABLE"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         34 "34 NOT EMPL AT INT DATE/NOT EMPL DUR RD 5/3" ;

label define H2010349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2010350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2010351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2010352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2010353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2016 "2016 YEAR"
         2017 "2017 YEAR" ;

label define H2010354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2016 "2016 YEAR"
         2017 "2017 YEAR" ;

label define H2010355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2017 "2017 YEAR" ;

label define H2010356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2017 "2017 YEAR"
         2018 "2018 YEAR" ;

label define H2010357X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010361X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H2010362X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H2010363X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H2010364X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H2010365X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H2010366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010367X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H2010368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H2010369X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H2010370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2010371X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010372X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H2010374X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010375X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2010377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2010378X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2010379X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H2010380X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H2010381X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010382X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010383X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2010384X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010385X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010386X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010387X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010388X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010389X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010390X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010391X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010392X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010393X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010394X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010396X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H2010397X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H2010398X
         -1 "-1 INAPPLICABLE"
         1 "1 MEXICAN/MEX AMER/CHICANO-NO OTHER HISP"
         2 "2 PUERTO RICAN -NO OTHER HISP REPORTED"
         3 "3 CUBAN/CUBAN AMERICAN -NO OTHER HISP RPTD"
         4 "4 DOMINICAN -NO OTHER HISP REPORTED"
         5 "5 CENTRAL OR SOUTH AMERICAN -NO OTHER HISP"
         6 "6 OTH LAT AM/HISP/LATINO/SPNSH ORGN-NO OTH"
         8 "8 MULTIPLE HISPANIC GROUPS REPORTED"
         9 "9 NON-HISPANIC" ;

label define H2010399X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2010400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H2010401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H2010402X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - HONORABLY DISCHARGED"
         2 "2 NO - NOT HONORABLY DISCHARGED"
         3 "3 16 OR YOUNGER - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H2010403X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010404X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010405X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010414X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010415X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010416X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010417X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010418X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010419X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010420X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010421X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010422X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010423X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010424X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010425X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010426X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010427X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010428X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010429X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010430X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010431X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010432X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010433X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010434X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010435X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010436X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010437X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010438X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010439X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010440X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010441X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010442X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010443X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010444X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010445X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010446X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010447X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010449X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010450X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010451X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010452X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010453X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010454X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010455X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010456X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010457X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010458X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010459X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010460X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010461X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010462X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010463X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010464X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010465X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010468X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010469X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010470X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010471X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010472X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010473X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010474X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010475X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010476X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010477X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010478X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010481X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010490X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H2010491X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H2010492X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H2010493X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H2010494X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $96.15"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010495X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H2010496X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $96.15"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010497X
         -1 "-1 INAPPLICABLE"
         -10 "-10 TOP-CODED WAGE" ;

label define H2010498X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $96.15"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010499X
         0 "0 NO"
         1 "1 YES" ;

label define H2010500X
         0 "0 NO"
         1 "1 YES" ;

label define H2010501X
         0 "0 NO"
         1 "1 YES" ;

label define H2010502X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010503X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010504X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY WELL"
         2 "2 WELL"
         3 "3 NOT WELL"
         4 "4 NOT AT ALL"
         5 "5 UNDER 5 AND OTHLANG=1, INAPPLICABLE" ;

label define H2010505X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010506X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2010507X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2010508X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2010509X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2010510X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2010511X
         -1 "-1 INAPPLICABLE"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H2010512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010522X
         1 "1 IN-SCOPE ON 12/31/2017"
         2 "2 NOT IN-SCOPE ON 12/31/2017" ;

label define H2010523X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/17"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2010524X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/17"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2010525X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/17"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2010526X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/17"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NOT IN MEPS RU NOW, PREVIOUSLY A MEMBER" ;

label define H2010527X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2017"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2017" ;

label define H2010528X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H2010529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010530X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010531X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010540X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010542X
         -1 "-1 INAPPLICABLE"
         1 "1 <65 ANY PRIVATE"
         2 "2 <65 PUBLIC ONLY"
         3 "3 <65 UNINSURED"
         4 "4 65+ EDITED MEDICARE ONLY"
         5 "5 65+ EDITED MEDICARE AND PRIVATE"
         6 "6 65+ EDITED MEDICARE AND OTH PUB ONLY"
         7 "7 65+ UNINSURED"
         8 "8 65+ NO MEDICARE AND ANY PUBLIC/PRIVATE" ;

label define H2010543X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2010544X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H2010545X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010546X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2010547X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2010548X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2010549X
         -1 "-1 INAPPLICABLE"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2010550X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2010552X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2010553X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H2010554X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010555X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010557X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010558X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H2010559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2010560X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPANISH"
         2 "2 ANOTHER LANGUAGE" ;

label define H2010562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT" ;

label define H2010564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H2010565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H2010567X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H2010568X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H2010569X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H2010570X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010571X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010572X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010583X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010584X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010585X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010586X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010587X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010588X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010589X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010591X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010592X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010594X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010595X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010596X
         1 "1 YES"
         2 "2 NO" ;

label define H2010597X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010598X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010599X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2010600X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2010601X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2010602X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010603X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010604X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010605X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010606X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010607X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010608X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010609X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010610X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2010611X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2010612X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H2010613X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010614X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010615X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010616X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010617X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010618X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010619X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010620X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010621X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010622X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010623X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010624X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010625X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010626X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010627X
         1 "1 YES"
         2 "2 NO" ;

label define H2010628X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010629X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010630X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010631X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010632X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010633X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010634X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010635X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010636X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010637X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010638X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010639X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010640X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010641X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010642X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010643X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010644X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010645X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010646X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PART B NOT ASC"
         1 "1 COV BY MEDICARE PART B"
         2 "2 COV BY MEDICARE - NOT PART B"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010647X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010648X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010649X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010650X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010651X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010652X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - PMED BENEFIT NOT ASC"
         1 "1 COV BY MEDICARE PMED BENEFIT"
         2 "2 COV BY MEDICARE - NOT PMED BENEFIT"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010653X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010654X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010655X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MEDICARE - MANAGED CARE NOT ASC"
         1 "1 COV BY MEDICARE MANAGED CARE"
         2 "2 COV BY MEDICARE - NOT MANAGED CARE"
         3 "3 NOT COV BY MEDICARE" ;

label define H2010656X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010657X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010658X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010659X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H2010660X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H2010662X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H2010663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010664X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H2010665X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010666X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010667X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010668X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2010669X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010670X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2010671X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2010672X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2010673X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2010674X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010676X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010677X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010678X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010680X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010681X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H2010682X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H2010683X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H2010684X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010685X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010686X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2010687X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010688X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010689X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >= $96.15"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010690X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$96.15"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010691X
         -1 "-1 INAPPLICABLE"
         -10 "-10 UPDATED HOURLY WAGE >=$96.15"
         -13 "-13 INITIAL WAGE IMPUTED"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010692X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010693X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010694X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010695X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010696X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H2010697X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010698X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010699X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010700X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010701X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010702X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010703X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H2010704X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H2010705X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H2010706X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010707X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010708X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2010709X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2010710X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2010711X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2010712X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2010713X
         -1 "-1 INAPPLICABLE"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NOT IN LABOR FORCE"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H2010714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010718X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010720X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010722X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010723X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010724X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010725X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010726X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010727X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EVERY DAY"
         2 "2 SOME DAYS"
         3 "3 NOT AT ALL" ;

label define H2010728X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010729X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010730X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010734X
         1 "1 YES"
         2 "2 NO" ;

label define H2010735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010740X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010741X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010742X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010743X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010744X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010745X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010746X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010747X
         1 "1 YES"
         2 "2 NO" ;

label define H2010748X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010749X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010750X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010751X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010752X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010753X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010754X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010755X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010756X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010757X
         0 "0.00"
         1 "$1" ;

label define H2010758X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010759X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010760X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010761X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2010762X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010763X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010764X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H2010765X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010766X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010767X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010768X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010769X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010770X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010771X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010772X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010773X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010774X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010775X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010776X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010777X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010778X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010779X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010780X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010781X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010782X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010783X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010784X
         21 "21 PANEL 21"
         22 "22 PANEL 22" ;

label define H2010785X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010786X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010787X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010788X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010789X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010790X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010791X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010792X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010793X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010794X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010795X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010796X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010797X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010798X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010799X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010800X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010801X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010802X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010803X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010804X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010805X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010806X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010807X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010808X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010809X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010810X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010811X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010812X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010813X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010814X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010815X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010816X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010817X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010818X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2010819X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010820X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H2010821X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H2010822X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010823X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010824X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H2010825X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010826X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010827X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010828X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H2010829X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010830X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010831X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010832X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H2010833X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H2010834X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE INSURANCE"
         2 "2 MEDICARE"
         3 "3 MEDICAID"
         4 "4 VA/CHAMPVA"
         5 "5 TRICARE"
         6 "6 STATE/LOCAL GOVERNMENT"
         7 "7 OTHER" ;

label define H2010835X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010836X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010837X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010838X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010839X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H2010840X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010841X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010842X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010843X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010844X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010845X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010846X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010847X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010848X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010849X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010850X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010851X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010852X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010853X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010854X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010855X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010856X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010857X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010858X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010859X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010860X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010861X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010862X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010863X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010864X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010865X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010866X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010867X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010868X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010869X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010870X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010871X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010872X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010873X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010874X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010875X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010876X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H2010877X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010878X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010879X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010880X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010881X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010882X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010883X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010884X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010885X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010886X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010887X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010888X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010889X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010890X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010891X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010892X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010893X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010894X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010895X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010896X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010897X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010898X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010899X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010900X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010901X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010902X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010903X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010904X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010905X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010906X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010907X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010908X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010909X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010910X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010911X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010912X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010913X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010917X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010918X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010919X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010920X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010924X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H2010925X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2010926X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2010927X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2010928X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H2010929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010935X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010938X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010945X
         1 "1 YES"
         2 "2 NO" ;

label define H2010946X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H2010947X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H2010948X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H2010949X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010950X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010951X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010952X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010953X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010954X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010955X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010956X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010957X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010958X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010959X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010960X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010961X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010962X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H2010963X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H2010964X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS-R1 ONLY"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R3/1"
         62 "62 INSTITUT PRIOR TO REF PER-R3/1"
         63 "63 LEFT U.S. PRIOR TO REF PER-R3/1"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R3/1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H2010965X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010966X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010967X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010968X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010969X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010970X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010971X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010972X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010973X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010974X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010975X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010976X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010977X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2010978X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010979X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010980X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010981X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010982X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010983X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010984X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010985X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010986X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010987X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010988X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010989X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2010990X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H2010991X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H2010992X
         -1 "-1 INAPPLICABLE"
         1 "1 HISPANIC"
         2 "2 NON-HISPANIC WHITE ONLY"
         3 "3 NON-HISPANIC BLACK ONLY"
         4 "4 NON-HISPANIC ASIAN ONLY"
         5 "5 NON-HISPANIC OTHER RACE OR MULTIPLE RACE" ;

label define H2010993X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H2010994X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         10 "10 OTH ASIAN/NATV HAWAIIAN/PACFC ISL-NO OTH"
         12 "12 MULTIPLE RACES REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE-NO OTHER RACE"
         4 "4 ASIAN INDIAN - NO OTHER RACE REPORTED"
         5 "5 CHINESE - NO OTHER RACE REPORTED"
         6 "6 FILIPINO - NO OTHER RACE REPORTED" ;

label define H2010995X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H2010996X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2010997X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2010998X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOP/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED" ;

label define H2010999X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H2011000X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H2011001X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOUSEHOLD REFERENCE PERSON"
         10 "10 AUNT/UNCLE"
         11 "11 NIECE/NEPHEW"
         2 "2 SPOUSE (HUSBAND/WIFE)"
         3 "3 UNMARRIED PARTNER"
         4 "4 CHILD BIOLOGICAL/ADOPT/STEP"
         5 "5 CHILD OF PARTNER"
         6 "6 GRANDCHILD"
         7 "7 PARENT BIOLOGICAL/ADOPT/STEP"
         8 "8 SIBLING BIOLOGICAL/ADOPT/STEP"
         9 "9 GRANDPARENT"
         91 "91 OTHER RELATED" ;

label define H2011002X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2011003X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2011004X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2011005X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H2011006X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2011007X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2011008X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2011009X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H2011010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H2011011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011012X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011013X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011014X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H2011015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2011016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2011017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H2011018X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011019X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011020X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011021X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2011022X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2011023X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2011024X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H2011025X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H2011026X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H2011027X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H2011028X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H2011029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011030X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2011031X
         0 "0 NOT ELIGIBLE FOR SAQ"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H2011032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2011033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2011035X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011036X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011037X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011038X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011040X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011041X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H2011043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2011044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011045X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011046X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011047X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011048X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011049X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011051X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H2011052X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H2011053X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H2011054X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H2011055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2011056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2011057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2011058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H2011059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2011060X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2011061X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2011062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H2011063X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H2011064X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H2011065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2011066X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2011067X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H2011068X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2011069X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2011070X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2011071X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2011072X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 COMPLETELY UNABLE TO DO IT"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H2011073X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H2011074X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011075X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H2011076X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H2011077X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H2011078X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H2011079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H2011081X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011082X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2011083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011084X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011085X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011086X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011087X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011088X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011089X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011090X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011091X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011092X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-CHAMPVA NOT ASC"
         1 "1 COV BY CHAMPVA"
         2 "2 COV BY TRICR/CHAMV-NOT CHAMPVA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011093X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011094X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011097X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011098X
         1 "1 YES"
         2 "2 NO" ;

label define H2011099X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011100X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011101X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI EXTRA NOT ASC"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011103X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011104X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011105X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011106X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011107X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011108X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI FOR LIFE NOT ASC"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011109X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011110X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011111X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011112X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011113X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011114X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011115X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI PRIME NOT ASC"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011116X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011117X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011118X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011119X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICR/CHAMV-TRI STANDARD NOT ASC"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICR/CHAMV-NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE/CHAMPVA" ;

label define H2011120X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2011121X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         15 "15 MD - ENDOCRINOLOGIST"
         16 "16 MD - GASTROENTEROLOGIST"
         17 "17 MD - GERIATRICIAN"
         18 "18 MD - NEPHROLOGIST"
         19 "19 MD - ONCOLOGIST"
         2 "2 MD - INTERNAL MEDICINE"
         20 "20 MD - PULMONOLOGIST"
         21 "21 MD - RHEUMATOLOGIST"
         22 "22 PSYCHIATRIST/PSYCHOLOGIST"
         23 "23 MD - NEUROLOGIST"
         24 "24 ALTERNATIVE CARE PROVIDER"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H2011122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011123X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2011124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H2011125X
         1 "1 YES"
         2 "2 NO" ;

label define H2011126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011127X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011128X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011129X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011130X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011131X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H2011132X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011133X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2011134X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H2011135X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H2011136X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H2011137X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2011138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011139X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011140X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011152X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H2011153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H2011165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H2011167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H2011170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H2011171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H2011172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 NO HEALTH INSURANCE"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         15 "15 HEALTH-RELATED REASONS"
         16 "16 NEWBORN - NO DOCTOR YET"
         17 "17 SELF, RELATIVE, OR FRIEND IS A DOCTOR"
         19 "19 CARE AVAILABLE ON JOB"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         22 "22 GOES TO HOSPITAL/EMERGENCY ROOM/CLINIC"
         23 "23 USES ALTERNATIVE CARE"
         24 "24 INSURANCE-RELATED REASONS"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H2011173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR"
         2 "2 1 YR., LESS THAN 5 YRS."
         3 "3 5 YRS., LESS THAN 10 YRS."
         4 "4 10 YRS., LESS THAN 15 YRS."
         5 "5 15 YEARS OR MORE" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H2010001X;
label value ACTDTY31 H2010002X;
label value ACTDTY42 H2010003X;
label value ACTDTY53 H2010004X;
label value ACTLIM31 H2010005X;
label value ADACLS42 H2010006X;
label value ADAPPT42 H2010007X;
label value ADCLIM42 H2010008X;
label value ADCMPM42 H2010009X;
label value ADCMPY42 H2010010X;
label value ADDAYA42 H2010011X;
label value ADDPRS42 H2010012X;
label value ADEFRT42 H2010013X;
label value ADEMLS42 H2010014X;
label value ADENGY42 H2010015X;
label value ADEXPL42 H2010016X;
label value ADEZUN42 H2010017X;
label value ADFFRM42 H2010018X;
label value ADFHLP42 H2010019X;
label value ADGENH42 H2010020X;
label value ADHDADDX H2010021X;
label value ADHDAGED H2010022X;
label value ADHECR42 H2010023X;
label value ADHOPE42 H2010024X;
label value ADILCR42 H2010025X;
label value ADILWW42 H2010026X;
label value ADINSA42 H2010027X;
label value ADINSB42 H2010028X;
label value ADINST42 H2010029X;
label value ADINTR42 H2010030X;
label value ADLANG42 H2010031X;
label value ADLHLP31 H2010032X;
label value ADLIST42 H2010033X;
label value ADMWCF42 H2010034X;
label value ADNERV42 H2010035X;
label value ADNSMK42 H2010036X;
label value ADOVER42 H2010037X;
label value ADPAIN42 H2010038X;
label value ADPCFL42 H2010039X;
label value ADPROX42 H2010040X;
label value ADPRST42 H2010041X;
label value ADPRTM42 H2010042X;
label value ADRESP42 H2010043X;
label value ADREST42 H2010044X;
label value ADRISK42 H2010045X;
label value ADRTCR42 H2010046X;
label value ADRTWW42 H2010047X;
label value ADSAD42 H2010048X;
label value ADSMOK42 H2010049X;
label value ADSNSP42 H2010050X;
label value ADSOCA42 H2010051X;
label value ADSPCL42 H2010052X;
label value ADTLHW42 H2010053X;
label value ADUPRO42 H2010054X;
label value ADWKLM42 H2010055X;
label value ADWRTH42 H2010056X;
label value AFTHOU42 H2010057X;
label value AIDHLP31 H2010058X;
label value ALIIMP17 H2010059X;
label value ANGIAGED H2010060X;
label value ANGIDX H2010061X;
label value ANYLMI17 H2010062X;
label value ARTHAGED H2010063X;
label value ARTHDX H2010064X;
label value ARTHTYPE H2010065X;
label value ASATAK31 H2010066X;
label value ASIANP42 H2010067X;
label value ASSTIL31 H2010068X;
label value ASTHAGED H2010069X;
label value ASTHDX H2010070X;
label value ASTHEP31 H2010071X;
label value BEGRFM31 H2010072X;
label value BEGRFM42 H2010073X;
label value BEGRFM53 H2010074X;
label value BEGRFY31 H2010075X;
label value BEGRFY42 H2010076X;
label value BEGRFY53 H2010077X;
label value BENDIF31 H2010078X;
label value BLCKPR42 H2010079X;
label value BLIND42 H2010080X;
label value BOOST42 H2010081X;
label value BORNUSA H2010082X;
label value BPMLDX H2010083X;
label value BSNTY31 H2010084X;
label value BSNTY31H H2010085X;
label value BSNTY42 H2010086X;
label value BSNTY42H H2010087X;
label value BSNTY53 H2010088X;
label value BSNTY53H H2010089X;
label value BUSIMP17 H2010090X;
label value CABLADDR H2010091X;
label value CABREAST H2010092X;
label value CACERVIX H2010093X;
label value CACOLON H2010094X;
label value CALUNG H2010095X;
label value CALYMPH H2010096X;
label value CAMELANO H2010097X;
label value CANCERDX H2010098X;
label value CAOTHER H2010099X;
label value CAPROSTA H2010100X;
label value CARECO42 H2010101X;
label value CASKINDK H2010102X;
label value CASKINNM H2010103X;
label value CAUTERUS H2010104X;
label value CBCK31 H2010105X;
label value CBCKYR31 H2010106X;
label value CCLHIN31 H2010107X;
label value CCNRDI31 H2010108X;
label value CDIAG31 H2010109X;
label value CDLFUP31 H2010110X;
label value CDLMNT31 H2010111X;
label value CDLOTH31 H2010112X;
label value CDLPRS31 H2010113X;
label value CDLTRT31 H2010114X;
label value CDLVST31 H2010115X;
label value CEFACT31 H2010116X;
label value CEFBCK31 H2010117X;
label value CEFCOP31 H2010118X;
label value CEFFTG31 H2010119X;
label value CEFHLT31 H2010120X;
label value CEFLCT31 H2010121X;
label value CEFMHL31 H2010122X;
label value CEFMPR31 H2010123X;
label value CEFMTL31 H2010124X;
label value CEFOG31 H2010125X;
label value CEFPAC31 H2010126X;
label value CEFPHL31 H2010127X;
label value CEFPIN31 H2010128X;
label value CEFPOS31 H2010129X;
label value CEFQLF31 H2010130X;
label value CEFRLT31 H2010131X;
label value CEFSTG31 H2010132X;
label value CEFUND31 H2010133X;
label value CERET31 H2010134X;
label value CEXTDI31 H2010135X;
label value CEXTLT31 H2010136X;
label value CEXTM31 H2010137X;
label value CEXTMT31 H2010138X;
label value CEXTRT31 H2010139X;
label value CFM2MT31 H2010140X;
label value CFMCHD31 H2010141X;
label value CFMEM31 H2010142X;
label value CFMFND31 H2010143X;
label value CFMOTR31 H2010144X;
label value CFMPAR31 H2010145X;
label value CFMREL31 H2010146X;
label value CFMSIB31 H2010147X;
label value CFMSPS31 H2010148X;
label value CFMTOF31 H2010149X;
label value CFNAMT31 H2010150X;
label value CFNBNK31 H2010151X;
label value CFNDBT31 H2010152X;
label value CFNINC31 H2010153X;
label value CFNLIV31 H2010154X;
label value CFNOTH31 H2010155X;
label value CFNPMT31 H2010156X;
label value CFNPUR31 H2010157X;
label value CFNSAV31 H2010158X;
label value CFNSPD31 H2010159X;
label value CFNSTB31 H2010160X;
label value CFNUNB31 H2010161X;
label value CFNVAC31 H2010162X;
label value CFRET31 H2010163X;
label value CFTRT31 H2010164X;
label value CHAPPT42 H2010165X;
label value CHBMIX42 H2010166X;
label value CHBRON31 H2010167X;
label value CHCOUN42 H2010168X;
label value CHDAGED H2010169X;
label value CHDDX H2010170X;
label value CHEMPB42 H2010171X;
label value CHENEC42 H2010172X;
label value CHEXPL42 H2010173X;
label value CHEYRE42 H2010174X;
label value CHGJ3142 H2010175X;
label value CHGJ4253 H2010176X;
label value CHHECR42 H2010177X;
label value CHILCR42 H2010178X;
label value CHILWW42 H2010179X;
label value CHLICO42 H2010180X;
label value CHLIHB42 H2010181X;
label value CHLIMI42 H2010182X;
label value CHLIMP17 H2010183X;
label value CHLIST42 H2010184X;
label value CHNDCR42 H2010185X;
label value CHOIC31 H2010186X;
label value CHOIC42 H2010187X;
label value CHOIC53 H2010188X;
label value CHOLAGED H2010189X;
label value CHOLDX H2010190X;
label value CHPMCN42 H2010191X;
label value CHPMED42 H2010192X;
label value CHPMHB42 H2010193X;
label value CHPRTM42 H2010194X;
label value CHRESP42 H2010195X;
label value CHRTCR42 H2010196X;
label value CHRTWW42 H2010197X;
label value CHSERV42 H2010198X;
label value CHSPEC42 H2010199X;
label value CHSRCN42 H2010200X;
label value CHSRHB42 H2010201X;
label value CHTHCO42 H2010202X;
label value CHTHER42 H2010203X;
label value CHTHHB42 H2010204X;
label value CINADQ31 H2010205X;
label value CINAFD31 H2010206X;
label value CINCMP31 H2010207X;
label value CINCOV31 H2010208X;
label value CINDIF31 H2010209X;
label value CINIHS31 H2010210X;
label value CINMDA31 H2010211X;
label value CINMDC31 H2010212X;
label value CINMDG31 H2010213X;
label value CINMLT31 H2010214X;
label value CINNCV31 H2010215X;
label value CINNOC31 H2010216X;
label value CINOGP31 H2010217X;
label value CINPRV31 H2010218X;
label value CINSHP31 H2010219X;
label value CINSSP31 H2010220X;
label value CLHINS31 H2010221X;
label value CLINIC42 H2010222X;
label value CLPROD31 H2010223X;
label value CLSTRT31 H2010224X;
label value CMCEFF31 H2010225X;
label value CMCFUP31 H2010226X;
label value CMCNEC31 H2010227X;
label value CMCOST31 H2010228X;
label value CMCPSY31 H2010229X;
label value CMCSTY31 H2010230X;
label value CMCTRT31 H2010231X;
label value CMJHLD31 H2010232X;
label value CMJHLD42 H2010233X;
label value CMJHLD53 H2010234X;
label value CMNACC31 H2010235X;
label value CMNAFF31 H2010236X;
label value CMNCRE31 H2010237X;
label value CMNINS31 H2010238X;
label value CMNLNG31 H2010239X;
label value CMNOFF31 H2010240X;
label value CMNPLC31 H2010241X;
label value CMNTIM31 H2010242X;
label value CMTASK31 H2010243X;
label value CNCCHD31 H2010244X;
label value CNCHME31 H2010245X;
label value CNCLOD31 H2010246X;
label value CNCMED31 H2010247X;
label value CNCNON31 H2010248X;
label value CNCNTS31 H2010249X;
label value CNCTRP31 H2010250X;
label value CNGFLX31 H2010251X;
label value CNPTLD31 H2010252X;
label value COGLIM31 H2010253X;
label value COVRMM H2010254X;
label value COVRYY H2010255X;
label value CPROM31 H2010256X;
label value CPTASK31 H2010257X;
label value CRFMPY42 H2010258X;
label value CSHCN42 H2010259X;
label value CSHIMP17 H2010260X;
label value CSLHIN31 H2010261X;
label value CTMOFF31 H2010262X;
label value CTRTMT31 H2010263X;
label value CWRKP31 H2010264X;
label value CWYCNG31 H2010265X;
label value DADPRO42 H2010266X;
label value DDNWRK17 H2010267X;
label value DEAF42 H2010268X;
label value DECIDE42 H2010269X;
label value DENTAL42 H2010270X;
label value DENTIN31 H2010271X;
label value DENTIN42 H2010272X;
label value DENTIN53 H2010273X;
label value DFCOG42 H2010274X;
label value DFDRSB42 H2010275X;
label value DFERND42 H2010276X;
label value DFHEAR42 H2010277X;
label value DFSEE42 H2010278X;
label value DFWLKC42 H2010279X;
label value DIABAGED H2010280X;
label value DIABDX H2010281X;
label value DIFFPL42 H2010282X;
label value DIFFWG31 H2010283X;
label value DIFFWG42 H2010284X;
label value DIFFWG53 H2010285X;
label value DISVW31X H2010286X;
label value DISVW42X H2010287X;
label value DISVW53X H2010288X;
label value DIVIMP17 H2010289X;
label value DKWHRU42 H2010290X;
label value DNDLAY42 H2010291X;
label value DNDLRS42 H2010292X;
label value DNTINS17 H2010293X;
label value DNTINS31 H2010294X;
label value DNUNAB42 H2010295X;
label value DNUNRS42 H2010296X;
label value DOBMM H2010297X;
label value DOBYY H2010298X;
label value DOCELS42 H2010299X;
label value DSA1C53 H2010300X;
label value DSCB1653 H2010301X;
label value DSCGRP53 H2010302X;
label value DSCH1653 H2010303X;
label value DSCH1753 H2010304X;
label value DSCH1853 H2010305X;
label value DSCHNV53 H2010306X;
label value DSCINT53 H2010307X;
label value DSCNPC53 H2010308X;
label value DSCONF53 H2010309X;
label value DSCPCP53 H2010310X;
label value DSCPHN53 H2010311X;
label value DSDIA53 H2010312X;
label value DSDIET53 H2010313X;
label value DSEB1653 H2010314X;
label value DSEY1653 H2010315X;
label value DSEY1753 H2010316X;
label value DSEY1853 H2010317X;
label value DSEYNV53 H2010318X;
label value DSEYPR53 H2010319X;
label value DSFB1653 H2010320X;
label value DSFL1653 H2010321X;
label value DSFL1753 H2010322X;
label value DSFL1853 H2010323X;
label value DSFLNV53 H2010324X;
label value DSFT1653 H2010325X;
label value DSFT1753 H2010326X;
label value DSFT1853 H2010327X;
label value DSFTNV53 H2010328X;
label value DSINSU53 H2010329X;
label value DSKIDN53 H2010330X;
label value DSMED53 H2010331X;
label value DSPRX53 H2010332X;
label value DSVB1653 H2010333X;
label value DVTOT17 H2010334X;
label value EATHLT42 H2010335X;
label value EDUCYR H2010336X;
label value ELGRND17 H2010337X;
label value ELGRND31 H2010338X;
label value ELGRND42 H2010339X;
label value ELGRND53 H2010340X;
label value EMPHAGED H2010341X;
label value EMPHDX H2010342X;
label value EMPST31 H2010343X;
label value EMPST31H H2010344X;
label value EMPST42 H2010345X;
label value EMPST42H H2010346X;
label value EMPST53 H2010347X;
label value EMPST53H H2010348X;
label value ENDRFM17 H2010349X;
label value ENDRFM31 H2010350X;
label value ENDRFM42 H2010351X;
label value ENDRFM53 H2010352X;
label value ENDRFY17 H2010353X;
label value ENDRFY31 H2010354X;
label value ENDRFY42 H2010355X;
label value ENDRFY53 H2010356X;
label value ERTOT17 H2010357X;
label value EVRETIRE H2010358X;
label value EVRWRK H2010359X;
label value EXPLOP42 H2010360X;
label value FAMRFPYR H2010361X;
label value FAMSZE31 H2010362X;
label value FAMSZE42 H2010363X;
label value FAMSZE53 H2010364X;
label value FCRP1231 H2010365X;
label value FILEDR17 H2010366X;
label value FILER17 H2010367X;
label value FLSTAT17 H2010368X;
label value FMRS1231 H2010369X;
label value FNGRDF31 H2010370X;
label value FOODMN17 H2010371X;
label value FOODST17 H2010372X;
label value FOODVL17 H2010373X;
label value FSAAMT31 H2010374X;
label value FSAGT31 H2010375X;
label value FTSTU17X H2010376X;
label value FTSTU31X H2010377X;
label value FTSTU42X H2010378X;
label value FTSTU53X H2010379X;
label value GENDRP42 H2010380X;
label value HASFSA31 H2010381X;
label value HAVEUS42 H2010382X;
label value HAVFUN42 H2010383X;
label value HEALTH42 H2010384X;
label value HEARAD42 H2010385X;
label value HELD31X H2010386X;
label value HELD42X H2010387X;
label value HELD53X H2010388X;
label value HELMET42 H2010389X;
label value HHAGD17 H2010390X;
label value HHINDD17 H2010391X;
label value HHINFD17 H2010392X;
label value HHTOTD17 H2010393X;
label value HIBPAGED H2010394X;
label value HIBPDX H2010395X;
label value HIDEG H2010396X;
label value HISPANX H2010397X;
label value HISPNCAT H2010398X;
label value HOMEBH42 H2010399X;
label value HONRDC31 H2010400X;
label value HONRDC42 H2010401X;
label value HONRDC53 H2010402X;
label value HOUR31 H2010403X;
label value HOUR42 H2010404X;
label value HOUR53 H2010405X;
label value HPDAP17 H2010406X;
label value HPDAU17 H2010407X;
label value HPDDE17 H2010408X;
label value HPDFE17 H2010409X;
label value HPDJA17 H2010410X;
label value HPDJL17 H2010411X;
label value HPDJU17 H2010412X;
label value HPDMA17 H2010413X;
label value HPDMY17 H2010414X;
label value HPDNO17 H2010415X;
label value HPDOC17 H2010416X;
label value HPDSE17 H2010417X;
label value HPEAP17 H2010418X;
label value HPEAU17 H2010419X;
label value HPEDE17 H2010420X;
label value HPEFE17 H2010421X;
label value HPEJA17 H2010422X;
label value HPEJL17 H2010423X;
label value HPEJU17 H2010424X;
label value HPEMA17 H2010425X;
label value HPEMY17 H2010426X;
label value HPENO17 H2010427X;
label value HPEOC17 H2010428X;
label value HPESE17 H2010429X;
label value HPNAP17 H2010430X;
label value HPNAU17 H2010431X;
label value HPNDE17 H2010432X;
label value HPNFE17 H2010433X;
label value HPNJA17 H2010434X;
label value HPNJL17 H2010435X;
label value HPNJU17 H2010436X;
label value HPNMA17 H2010437X;
label value HPNMY17 H2010438X;
label value HPNNO17 H2010439X;
label value HPNOC17 H2010440X;
label value HPNSE17 H2010441X;
label value HPOAP17 H2010442X;
label value HPOAU17 H2010443X;
label value HPODE17 H2010444X;
label value HPOFE17 H2010445X;
label value HPOJA17 H2010446X;
label value HPOJL17 H2010447X;
label value HPOJU17 H2010448X;
label value HPOMA17 H2010449X;
label value HPOMY17 H2010450X;
label value HPONO17 H2010451X;
label value HPOOC17 H2010452X;
label value HPOSE17 H2010453X;
label value HPRAP17 H2010454X;
label value HPRAU17 H2010455X;
label value HPRDE17 H2010456X;
label value HPRFE17 H2010457X;
label value HPRJA17 H2010458X;
label value HPRJL17 H2010459X;
label value HPRJU17 H2010460X;
label value HPRMA17 H2010461X;
label value HPRMY17 H2010462X;
label value HPRNO17 H2010463X;
label value HPROC17 H2010464X;
label value HPRSE17 H2010465X;
label value HPSAP17 H2010466X;
label value HPSAU17 H2010467X;
label value HPSDE17 H2010468X;
label value HPSFE17 H2010469X;
label value HPSJA17 H2010470X;
label value HPSJL17 H2010471X;
label value HPSJU17 H2010472X;
label value HPSMA17 H2010473X;
label value HPSMY17 H2010474X;
label value HPSNO17 H2010475X;
label value HPSOC17 H2010476X;
label value HPSSE17 H2010477X;
label value HPXAP17 H2010478X;
label value HPXAU17 H2010479X;
label value HPXDE17 H2010480X;
label value HPXFE17 H2010481X;
label value HPXJA17 H2010482X;
label value HPXJL17 H2010483X;
label value HPXJU17 H2010484X;
label value HPXMA17 H2010485X;
label value HPXMY17 H2010486X;
label value HPXNO17 H2010487X;
label value HPXOC17 H2010488X;
label value HPXSE17 H2010489X;
label value HRHOW31 H2010490X;
label value HRHOW42 H2010491X;
label value HRHOW53 H2010492X;
label value HRWG31H H2010493X;
label value HRWG31X H2010494X;
label value HRWG42H H2010495X;
label value HRWG42X H2010496X;
label value HRWG53H H2010497X;
label value HRWG53X H2010498X;
label value HRWGIM31 H2010499X;
label value HRWGIM42 H2010500X;
label value HRWGIM53 H2010501X;
label value HSELIM31 H2010502X;
label value HSPLAP42 H2010503X;
label value HWELLSPE H2010504X;
label value IADLHP31 H2010505X;
label value INDCAT31 H2010506X;
label value INDCAT42 H2010507X;
label value INDCAT53 H2010508X;
label value INDCT31H H2010509X;
label value INDCT42H H2010510X;
label value INDCT53H H2010511X;
label value INS17X H2010512X;
label value INS31X H2010513X;
label value INS42X H2010514X;
label value INS53X H2010515X;
label value INSAP17X H2010516X;
label value INSAT17X H2010517X;
label value INSAT31X H2010518X;
label value INSAT42X H2010519X;
label value INSAT53X H2010520X;
label value INSAU17X H2010521X;
label value INSC1231 H2010522X;
label value INSCOP17 H2010523X;
label value INSCOP31 H2010524X;
label value INSCOP42 H2010525X;
label value INSCOP53 H2010526X;
label value INSCOPE H2010527X;
label value INSCOV17 H2010528X;
label value INSDE17X H2010529X;
label value INSENDMM H2010530X;
label value INSENDYY H2010531X;
label value INSFE17X H2010532X;
label value INSJA17X H2010533X;
label value INSJL17X H2010534X;
label value INSJU17X H2010535X;
label value INSMA17X H2010536X;
label value INSMY17X H2010537X;
label value INSNO17X H2010538X;
label value INSOC17X H2010539X;
label value INSRPL42 H2010540X;
label value INSSE17X H2010541X;
label value INSURC17 H2010542X;
label value INTIMP17 H2010543X;
label value INTVLANG H2010544X;
label value IPDIS17 H2010545X;
label value IRAIMP17 H2010546X;
label value JBORG31H H2010547X;
label value JBORG42H H2010548X;
label value JBORG53H H2010549X;
label value JNTPID17 H2010550X;
label value JOBORG31 H2010551X;
label value JOBORG42 H2010552X;
label value JOBORG53 H2010553X;
label value JOBRSN42 H2010554X;
label value JTINRU17 H2010555X;
label value JTPAIN31 H2010556X;
label value K6SUM42 H2010557X;
label value KEYNESS H2010558X;
label value KIDPRO42 H2010559X;
label value KNOWDR42 H2010560X;
label value LANGSPK H2010561X;
label value LAPBLT42 H2010562X;
label value LFTDIF31 H2010563X;
label value LOCATN42 H2010564X;
label value LSTETH53 H2010565X;
label value MARRY17X H2010566X;
label value MARRY31X H2010567X;
label value MARRY42X H2010568X;
label value MARRY53X H2010569X;
label value MCAID17 H2010570X;
label value MCAID17X H2010571X;
label value MCAID31 H2010572X;
label value MCAID31X H2010573X;
label value MCAID42 H2010574X;
label value MCAID42X H2010575X;
label value MCAID53 H2010576X;
label value MCAID53X H2010577X;
label value MCARE17 H2010578X;
label value MCARE17X H2010579X;
label value MCARE31 H2010580X;
label value MCARE31X H2010581X;
label value MCARE42 H2010582X;
label value MCARE42X H2010583X;
label value MCARE53 H2010584X;
label value MCARE53X H2010585X;
label value MCDAP17 H2010586X;
label value MCDAP17X H2010587X;
label value MCDAT17X H2010588X;
label value MCDAT31X H2010589X;
label value MCDAT42X H2010590X;
label value MCDAT53X H2010591X;
label value MCDAU17 H2010592X;
label value MCDAU17X H2010593X;
label value MCDDE17 H2010594X;
label value MCDDE17X H2010595X;
label value MCDEV17 H2010596X;
label value MCDFE17 H2010597X;
label value MCDFE17X H2010598X;
label value MCDHMO17 H2010599X;
label value MCDHMO31 H2010600X;
label value MCDHMO42 H2010601X;
label value MCDJA17 H2010602X;
label value MCDJA17X H2010603X;
label value MCDJL17 H2010604X;
label value MCDJL17X H2010605X;
label value MCDJU17 H2010606X;
label value MCDJU17X H2010607X;
label value MCDMA17 H2010608X;
label value MCDMA17X H2010609X;
label value MCDMC17 H2010610X;
label value MCDMC31 H2010611X;
label value MCDMC42 H2010612X;
label value MCDMY17 H2010613X;
label value MCDMY17X H2010614X;
label value MCDNO17 H2010615X;
label value MCDNO17X H2010616X;
label value MCDOC17 H2010617X;
label value MCDOC17X H2010618X;
label value MCDSE17 H2010619X;
label value MCDSE17X H2010620X;
label value MCRAP17 H2010621X;
label value MCRAP17X H2010622X;
label value MCRAU17 H2010623X;
label value MCRAU17X H2010624X;
label value MCRDE17 H2010625X;
label value MCRDE17X H2010626X;
label value MCREV17 H2010627X;
label value MCRFE17 H2010628X;
label value MCRFE17X H2010629X;
label value MCRJA17 H2010630X;
label value MCRJA17X H2010631X;
label value MCRJL17 H2010632X;
label value MCRJL17X H2010633X;
label value MCRJU17 H2010634X;
label value MCRJU17X H2010635X;
label value MCRMA17 H2010636X;
label value MCRMA17X H2010637X;
label value MCRMY17 H2010638X;
label value MCRMY17X H2010639X;
label value MCRNO17 H2010640X;
label value MCRNO17X H2010641X;
label value MCROC17 H2010642X;
label value MCROC17X H2010643X;
label value MCRPB17 H2010644X;
label value MCRPB31 H2010645X;
label value MCRPB42 H2010646X;
label value MCRPD17 H2010647X;
label value MCRPD17X H2010648X;
label value MCRPD31 H2010649X;
label value MCRPD31X H2010650X;
label value MCRPD42 H2010651X;
label value MCRPD42X H2010652X;
label value MCRPHO17 H2010653X;
label value MCRPHO31 H2010654X;
label value MCRPHO42 H2010655X;
label value MCRSE17 H2010656X;
label value MCRSE17X H2010657X;
label value MDDLAY42 H2010658X;
label value MDDLRS42 H2010659X;
label value MDUNAB42 H2010660X;
label value MDUNRS42 H2010661X;
label value MESBPR42 H2010662X;
label value MESHGT42 H2010663X;
label value MESVIS42 H2010664X;
label value MESWGT42 H2010665X;
label value MIAGED H2010666X;
label value MIDX H2010667X;
label value MILDIF31 H2010668X;
label value MINORP42 H2010669X;
label value MNHLTH31 H2010670X;
label value MNHLTH42 H2010671X;
label value MNHLTH53 H2010672X;
label value MOMPRO42 H2010673X;
label value MORE31 H2010674X;
label value MORE31H H2010675X;
label value MORE42 H2010676X;
label value MORE42H H2010677X;
label value MORE53 H2010678X;
label value MORE53H H2010679X;
label value MORECOVR H2010680X;
label value MORJOB31 H2010681X;
label value MORJOB42 H2010682X;
label value MORJOB53 H2010683X;
label value MYSELF42 H2010684X;
label value NATAMP42 H2010685X;
label value NERVAF42 H2010686X;
label value NEWARE42 H2010687X;
label value NEWDOC42 H2010688X;
label value NHRWG31 H2010689X;
label value NHRWG42 H2010690X;
label value NHRWG53 H2010691X;
label value NOGODR42 H2010692X;
label value NOHINS42 H2010693X;
label value NOINSBEF H2010694X;
label value NOINSTM H2010695X;
label value NOINUNIT H2010696X;
label value NOLIKE42 H2010697X;
label value NOREAS42 H2010698X;
label value NOSMOK42 H2010699X;
label value NUMEMP31 H2010700X;
label value NUMEMP42 H2010701X;
label value NUMEMP53 H2010702X;
label value NWK31 H2010703X;
label value NWK42 H2010704X;
label value NWK53 H2010705X;
label value OBDRV17 H2010706X;
label value OBTOTV17 H2010707X;
label value OCCCAT31 H2010708X;
label value OCCCAT42 H2010709X;
label value OCCCAT53 H2010710X;
label value OCCCT31H H2010711X;
label value OCCCT42H H2010712X;
label value OCCCT53H H2010713X;
label value OFEMP31H H2010714X;
label value OFEMP42H H2010715X;
label value OFEMP53H H2010716X;
label value OFFER31H H2010717X;
label value OFFER31X H2010718X;
label value OFFER42H H2010719X;
label value OFFER42X H2010720X;
label value OFFER53H H2010721X;
label value OFFER53X H2010722X;
label value OFFHOU42 H2010723X;
label value OFREMP31 H2010724X;
label value OFREMP42 H2010725X;
label value OFREMP53 H2010726X;
label value OFTSMK53 H2010727X;
label value OHRTAGED H2010728X;
label value OHRTDX H2010729X;
label value ONGONG42 H2010730X;
label value OPAAP17 H2010731X;
label value OPAAU17 H2010732X;
label value OPADE17 H2010733X;
label value OPAEV17 H2010734X;
label value OPAFE17 H2010735X;
label value OPAJA17 H2010736X;
label value OPAJL17 H2010737X;
label value OPAJU17 H2010738X;
label value OPAMA17 H2010739X;
label value OPAMY17 H2010740X;
label value OPANO17 H2010741X;
label value OPAOC17 H2010742X;
label value OPASE17 H2010743X;
label value OPBAP17 H2010744X;
label value OPBAU17 H2010745X;
label value OPBDE17 H2010746X;
label value OPBEV17 H2010747X;
label value OPBFE17 H2010748X;
label value OPBJA17 H2010749X;
label value OPBJL17 H2010750X;
label value OPBJU17 H2010751X;
label value OPBMA17 H2010752X;
label value OPBMY17 H2010753X;
label value OPBNO17 H2010754X;
label value OPBOC17 H2010755X;
label value OPBSE17 H2010756X;
label value OPDOFD17 H2010757X;
label value OPDRV17 H2010758X;
label value OPTOTV17 H2010759X;
label value OTHDYS17 H2010760X;
label value OTHIMP17 H2010761X;
label value OTHINS42 H2010762X;
label value OTHLANG H2010763X;
label value OTHNDD17 H2010764X;
label value OTHRCP42 H2010765X;
label value OTHREA42 H2010766X;
label value OTPAAT17 H2010767X;
label value OTPAAT31 H2010768X;
label value OTPAAT42 H2010769X;
label value OTPAAT53 H2010770X;
label value OTPBAT17 H2010771X;
label value OTPBAT31 H2010772X;
label value OTPBAT42 H2010773X;
label value OTPBAT53 H2010774X;
label value OTPUBA17 H2010775X;
label value OTPUBA31 H2010776X;
label value OTPUBA42 H2010777X;
label value OTPUBA53 H2010778X;
label value OTPUBB17 H2010779X;
label value OTPUBB31 H2010780X;
label value OTPUBB42 H2010781X;
label value OTPUBB53 H2010782X;
label value PACISP42 H2010783X;
label value PANEL H2010784X;
label value PAYDR31 H2010785X;
label value PAYDR31H H2010786X;
label value PAYDR42 H2010787X;
label value PAYDR42H H2010788X;
label value PAYDR53 H2010789X;
label value PAYDR53H H2010790X;
label value PAYVAC31 H2010791X;
label value PAYVAC42 H2010792X;
label value PAYVAC53 H2010793X;
label value PDKAP17 H2010794X;
label value PDKAU17 H2010795X;
label value PDKDE17 H2010796X;
label value PDKFE17 H2010797X;
label value PDKJA17 H2010798X;
label value PDKJL17 H2010799X;
label value PDKJU17 H2010800X;
label value PDKMA17 H2010801X;
label value PDKMY17 H2010802X;
label value PDKNO17 H2010803X;
label value PDKOC17 H2010804X;
label value PDKSE17 H2010805X;
label value PEGAP17 H2010806X;
label value PEGAU17 H2010807X;
label value PEGDE17 H2010808X;
label value PEGFE17 H2010809X;
label value PEGJA17 H2010810X;
label value PEGJL17 H2010811X;
label value PEGJU17 H2010812X;
label value PEGMA17 H2010813X;
label value PEGMY17 H2010814X;
label value PEGNO17 H2010815X;
label value PEGOC17 H2010816X;
label value PEGSE17 H2010817X;
label value PENIMP17 H2010818X;
label value PERSLA42 H2010819X;
label value PHNREG42 H2010820X;
label value PHQ242 H2010821X;
label value PHYEXE53 H2010822X;
label value PHYSCL42 H2010823X;
label value PLCTYP42 H2010824X;
label value PMDINS17 H2010825X;
label value PMDINS31 H2010826X;
label value PMDLAY42 H2010827X;
label value PMDLRS42 H2010828X;
label value PMEDIN31 H2010829X;
label value PMEDIN42 H2010830X;
label value PMEDIN53 H2010831X;
label value PMEDPY31 H2010832X;
label value PMEDPY42 H2010833X;
label value PMEDPY53 H2010834X;
label value PMEDUP31 H2010835X;
label value PMEDUP42 H2010836X;
label value PMEDUP53 H2010837X;
label value PMUNAB42 H2010838X;
label value PMUNRS42 H2010839X;
label value PNGAP17 H2010840X;
label value PNGAU17 H2010841X;
label value PNGDE17 H2010842X;
label value PNGFE17 H2010843X;
label value PNGJA17 H2010844X;
label value PNGJL17 H2010845X;
label value PNGJU17 H2010846X;
label value PNGMA17 H2010847X;
label value PNGMY17 H2010848X;
label value PNGNO17 H2010849X;
label value PNGOC17 H2010850X;
label value PNGSE17 H2010851X;
label value POGAP17 H2010852X;
label value POGAU17 H2010853X;
label value POGDE17 H2010854X;
label value POGFE17 H2010855X;
label value POGJA17 H2010856X;
label value POGJL17 H2010857X;
label value POGJU17 H2010858X;
label value POGMA17 H2010859X;
label value POGMY17 H2010860X;
label value POGNO17 H2010861X;
label value POGOC17 H2010862X;
label value POGSE17 H2010863X;
label value POUAP17 H2010864X;
label value POUAU17 H2010865X;
label value POUDE17 H2010866X;
label value POUFE17 H2010867X;
label value POUJA17 H2010868X;
label value POUJL17 H2010869X;
label value POUJU17 H2010870X;
label value POUMA17 H2010871X;
label value POUMY17 H2010872X;
label value POUNO17 H2010873X;
label value POUOC17 H2010874X;
label value POUSE17 H2010875X;
label value POVCAT17 H2010876X;
label value PREVCOVR H2010877X;
label value PREVEN42 H2010878X;
label value PRIAP17 H2010879X;
label value PRIAU17 H2010880X;
label value PRIDE17 H2010881X;
label value PRIDK17 H2010882X;
label value PRIDK31 H2010883X;
label value PRIDK42 H2010884X;
label value PRIDK53 H2010885X;
label value PRIEU17 H2010886X;
label value PRIEU31 H2010887X;
label value PRIEU42 H2010888X;
label value PRIEU53 H2010889X;
label value PRIFE17 H2010890X;
label value PRIJA17 H2010891X;
label value PRIJL17 H2010892X;
label value PRIJU17 H2010893X;
label value PRIMA17 H2010894X;
label value PRIMY17 H2010895X;
label value PRING17 H2010896X;
label value PRING31 H2010897X;
label value PRING42 H2010898X;
label value PRING53 H2010899X;
label value PRINO17 H2010900X;
label value PRIOC17 H2010901X;
label value PRIOG17 H2010902X;
label value PRIOG31 H2010903X;
label value PRIOG42 H2010904X;
label value PRIOG53 H2010905X;
label value PRIS17 H2010906X;
label value PRIS31 H2010907X;
label value PRIS42 H2010908X;
label value PRIS53 H2010909X;
label value PRISE17 H2010910X;
label value PRIV17 H2010911X;
label value PRIV31 H2010912X;
label value PRIV42 H2010913X;
label value PRIV53 H2010914X;
label value PRIVAT17 H2010915X;
label value PRIVAT31 H2010916X;
label value PRIVAT42 H2010917X;
label value PRIVAT53 H2010918X;
label value PROBPY42 H2010919X;
label value PROUT17 H2010920X;
label value PROUT31 H2010921X;
label value PROUT42 H2010922X;
label value PROUT53 H2010923X;
label value PROVTY42 H2010924X;
label value PROXY17 H2010925X;
label value PROXY31 H2010926X;
label value PROXY42 H2010927X;
label value PROXY53 H2010928X;
label value PRSAP17 H2010929X;
label value PRSAU17 H2010930X;
label value PRSDE17 H2010931X;
label value PRSFE17 H2010932X;
label value PRSJA17 H2010933X;
label value PRSJL17 H2010934X;
label value PRSJU17 H2010935X;
label value PRSMA17 H2010936X;
label value PRSMY17 H2010937X;
label value PRSNO17 H2010938X;
label value PRSOC17 H2010939X;
label value PRSSE17 H2010940X;
label value PRSTX17 H2010941X;
label value PRSTX31 H2010942X;
label value PRSTX42 H2010943X;
label value PRSTX53 H2010944X;
label value PRVEV17 H2010945X;
label value PRVHMO17 H2010946X;
label value PRVHMO31 H2010947X;
label value PRVHMO42 H2010948X;
label value PRVSPK42 H2010949X;
label value PRXAP17 H2010950X;
label value PRXAU17 H2010951X;
label value PRXDE17 H2010952X;
label value PRXFE17 H2010953X;
label value PRXJA17 H2010954X;
label value PRXJL17 H2010955X;
label value PRXJU17 H2010956X;
label value PRXMA17 H2010957X;
label value PRXMY17 H2010958X;
label value PRXNO17 H2010959X;
label value PRXOC17 H2010960X;
label value PRXSE17 H2010961X;
label value PSTATS31 H2010962X;
label value PSTATS42 H2010963X;
label value PSTATS53 H2010964X;
label value PUB17X H2010965X;
label value PUB31X H2010966X;
label value PUB42X H2010967X;
label value PUB53X H2010968X;
label value PUBAP17X H2010969X;
label value PUBAT17X H2010970X;
label value PUBAT31X H2010971X;
label value PUBAT42X H2010972X;
label value PUBAT53X H2010973X;
label value PUBAU17X H2010974X;
label value PUBDE17X H2010975X;
label value PUBFE17X H2010976X;
label value PUBIMP17 H2010977X;
label value PUBJA17X H2010978X;
label value PUBJL17X H2010979X;
label value PUBJU17X H2010980X;
label value PUBMA17X H2010981X;
label value PUBMY17X H2010982X;
label value PUBNO17X H2010983X;
label value PUBOC17X H2010984X;
label value PUBSE17X H2010985X;
label value PYUNBL42 H2010986X;
label value PYVAC31H H2010987X;
label value PYVAC42H H2010988X;
label value PYVAC53H H2010989X;
label value RACEAX H2010990X;
label value RACEBX H2010991X;
label value RACETHX H2010992X;
label value RACEV1X H2010993X;
label value RACEV2X H2010994X;
label value RACEWX H2010995X;
label value RCHDIF31 H2010996X;
label value REFFRL42 H2010997X;
label value REFRL17X H2010998X;
label value REFRL31X H2010999X;
label value REFRL42X H2011000X;
label value REFRL53X H2011001X;
label value REGION17 H2011002X;
label value REGION31 H2011003X;
label value REGION42 H2011004X;
label value REGION53 H2011005X;
label value RESP17 H2011006X;
label value RESP31 H2011007X;
label value RESP42 H2011008X;
label value RESP53 H2011009X;
label value RESPCT42 H2011010X;
label value RETPLN31 H2011011X;
label value RETPLN42 H2011012X;
label value RETPLN53 H2011013X;
label value RNDFLG31 H2011014X;
label value RTHLTH31 H2011015X;
label value RTHLTH42 H2011016X;
label value RTHLTH53 H2011017X;
label value RTPLN31H H2011018X;
label value RTPLN42H H2011019X;
label value RTPLN53H H2011020X;
label value RUCLAS17 H2011021X;
label value RUCLAS31 H2011022X;
label value RUCLAS42 H2011023X;
label value RUCLAS53 H2011024X;
label value RUSIZE17 H2011025X;
label value RUSIZE31 H2011026X;
label value RUSIZE42 H2011027X;
label value RUSIZE53 H2011028X;
label value SAFEST42 H2011029X;
label value SALIMP17 H2011030X;
label value SAQELIG H2011031X;
label value SCHLBH42 H2011032X;
label value SCHLIM31 H2011033X;
label value SCHPRO42 H2011034X;
label value SCPAY31H H2011035X;
label value SCPAY42H H2011036X;
label value SCPAY53H H2011037X;
label value SELDSI42 H2011038X;
label value SELFCM31 H2011039X;
label value SELFCM42 H2011040X;
label value SELFCM53 H2011041X;
label value SEX H2011042X;
label value SIBPRO42 H2011043X;
label value SICPAY31 H2011044X;
label value SICPAY42 H2011045X;
label value SICPAY53 H2011046X;
label value SLFCM31H H2011047X;
label value SLFCM42H H2011048X;
label value SLFCM53H H2011049X;
label value SOCLIM31 H2011050X;
label value SPOUID17 H2011051X;
label value SPOUID31 H2011052X;
label value SPOUID42 H2011053X;
label value SPOUID53 H2011054X;
label value SPOUIN17 H2011055X;
label value SPOUIN31 H2011056X;
label value SPOUIN42 H2011057X;
label value SPOUIN53 H2011058X;
label value SPRPRO42 H2011059X;
label value SSCIMP17 H2011060X;
label value SSIIMP17 H2011061X;
label value SSNLJB31 H2011062X;
label value SSNLJB42 H2011063X;
label value SSNLJB53 H2011064X;
label value STJBMM31 H2011065X;
label value STJBMM42 H2011066X;
label value STJBMM53 H2011067X;
label value STJBYY31 H2011068X;
label value STJBYY42 H2011069X;
label value STJBYY53 H2011070X;
label value STNDIF31 H2011071X;
label value STPDIF31 H2011072X;
label value STRKAGED H2011073X;
label value STRKDX H2011074X;
label value TAXFRM17 H2011075X;
label value TEMPJB31 H2011076X;
label value TEMPJB42 H2011077X;
label value TEMPJB53 H2011078X;
label value TIMALN42 H2011079X;
label value TMTKUS42 H2011080X;
label value TRANS42 H2011081X;
label value TRBLE42 H2011082X;
label value TREATM42 H2011083X;
label value TRIAP17X H2011084X;
label value TRIAT17X H2011085X;
label value TRIAT31X H2011086X;
label value TRIAT42X H2011087X;
label value TRIAT53X H2011088X;
label value TRIAU17X H2011089X;
label value TRICH17X H2011090X;
label value TRICH31X H2011091X;
label value TRICH42X H2011092X;
label value TRICR17X H2011093X;
label value TRICR31X H2011094X;
label value TRICR42X H2011095X;
label value TRICR53X H2011096X;
label value TRIDE17X H2011097X;
label value TRIEV17 H2011098X;
label value TRIEX17X H2011099X;
label value TRIEX31X H2011100X;
label value TRIEX42X H2011101X;
label value TRIFE17X H2011102X;
label value TRIJA17X H2011103X;
label value TRIJL17X H2011104X;
label value TRIJU17X H2011105X;
label value TRILI17X H2011106X;
label value TRILI31X H2011107X;
label value TRILI42X H2011108X;
label value TRIMA17X H2011109X;
label value TRIMY17X H2011110X;
label value TRINO17X H2011111X;
label value TRIOC17X H2011112X;
label value TRIPR17X H2011113X;
label value TRIPR31X H2011114X;
label value TRIPR42X H2011115X;
label value TRISE17X H2011116X;
label value TRIST17X H2011117X;
label value TRIST31X H2011118X;
label value TRIST42X H2011119X;
label value TRTIMP17 H2011120X;
label value TYPEPE42 H2011121X;
label value UNABLE31 H2011122X;
label value UNEIMP17 H2011123X;
label value UNHAP42 H2011124X;
label value UNINS17 H2011125X;
label value UNION31 H2011126X;
label value UNION31H H2011127X;
label value UNION42 H2011128X;
label value UNION42H H2011129X;
label value UNION53 H2011130X;
label value UNION53H H2011131X;
label value USCNOT42 H2011132X;
label value VETIMP17 H2011133X;
label value VMCS42 H2011134X;
label value VPCS42 H2011135X;
label value VRFLAG42 H2011136X;
label value WAGIMP17 H2011137X;
label value WASAFDC H2011138X;
label value WASCHAMP H2011139X;
label value WASESTB H2011140X;
label value WASMCAID H2011141X;
label value WASMCARE H2011142X;
label value WASOTGOV H2011143X;
label value WASOTHER H2011144X;
label value WASPRIV H2011145X;
label value WASSSI H2011146X;
label value WASSTAT1 H2011147X;
label value WASSTAT2 H2011148X;
label value WASSTAT3 H2011149X;
label value WASSTAT4 H2011150X;
label value WASVA H2011151X;
label value WCPIMP17 H2011152X;
label value WHITPR42 H2011153X;
label value WHNBPR42 H2011154X;
label value WHNBST42 H2011155X;
label value WHNDEN42 H2011156X;
label value WHNEAT42 H2011157X;
label value WHNHEL42 H2011158X;
label value WHNHGT42 H2011159X;
label value WHNLAP42 H2011160X;
label value WHNPHY42 H2011161X;
label value WHNSAF42 H2011162X;
label value WHNSMK42 H2011163X;
label value WHNWGT42 H2011164X;
label value WILFIL17 H2011165X;
label value WLKDIF31 H2011166X;
label value WLKLIM31 H2011167X;
label value WRGLAS42 H2011168X;
label value WRKLIM31 H2011169X;
label value YCHJ3142 H2011170X;
label value YCHJ4253 H2011171X;
label value YNOUSC42 H2011172X;
label value YRSINUS H2011173X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H201.LOG and a data file named H201.DTA.  If these files (H201.DTA and H201.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

